% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergenceDFM-package.R
\docType{package}
\name{convergenceDFM-package}
\alias{convergenceDFM}
\alias{convergenceDFM-package}
\title{convergenceDFM: Dynamic Factor Models for Economic Convergence Analysis}
\description{
Tools to analyze economic convergence using Dynamic Factor Models (DFM) and
Factor Ornstein-Uhlenbeck (OU) processes. Includes data preparation, PLS-based
factor selection, DFM estimation with robust inference, OU estimation (Stan
or fallback), formal convergence tests, robustness checks, rotation/coupling
tests, and visualization utilities.
}
\section{Main functions}{

\itemize{
\item \code{\link{run_complete_factor_analysis_robust}}: End-to-end pipeline.
\item \code{\link{estimate_DFM}}: Estimate a VAR-based Dynamic Factor Model.
\item \code{\link{estimate_factor_OU}}: Estimate Factor OU model (Stan or fallback).
\item \code{\link{run_convergence_robustness_tests}}: Robustness test suite.
\item \code{\link{visualize_factor_dynamics}}: Visualization helpers.
}
}

\seealso{
\code{vignette("convergence-analysis")}
}
\author{
\strong{Maintainer}: José Mauricio Gómez Julián \email{isadorenabi@pm.me}

}
\keyword{internal}
