% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_seq_cos_sim.R
\name{get_seq_cos_sim}
\alias{get_seq_cos_sim}
\title{Calculate cosine similarities between target word and candidates words over
sequenced variable using ALC embedding approach}
\usage{
get_seq_cos_sim(
  x,
  seqvar,
  target,
  candidates,
  pre_trained,
  transform_matrix,
  window = 6,
  valuetype = "fixed",
  case_insensitive = TRUE,
  hard_cut = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{(character) vector - this is the set of documents (corpus) of interest}

\item{seqvar}{ordered variable such as list of dates or ordered iseology scores}

\item{target}{(character) vector - target word}

\item{candidates}{(character) vector of features of interest}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{window}{(numeric) - defines the size of a context (words around the target).}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link[quanteda]{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link[quanteda]{dictionary} values}

\item{hard_cut}{(logical) - if TRUE then a context must have \code{window} x 2 tokens,
if FALSE it can have \code{window} x 2 or fewer (e.g. if a doc begins with a target word,
then context will have \code{window} tokens rather than \code{window} x 2)}

\item{verbose}{(logical) - if TRUE, report the total number of target instances found.}
}
\value{
a data.frame with one column for
each candidate term with corresponding cosine similarity values
and one column for seqvar.
}
\description{
Calculate cosine similarities between target word and candidates words over
sequenced variable using ALC embedding approach
}
\examples{

library(quanteda)
# gen sequence var (here: year)
docvars(cr_sample_corpus, 'year') <- rep(2011:2014, each = 50)
cos_simsdf <- get_seq_cos_sim(x = cr_sample_corpus,
seqvar = docvars(cr_sample_corpus, 'year'),
target = "equal",
candidates = c("immigration", "immigrants"),
pre_trained = cr_glove_subset,
transform_matrix = cr_transform)
}
