% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_sim.R
\name{feature_sim}
\alias{feature_sim}
\title{Given two feature-embedding-matrices, compute "parallel" cosine similarities
between overlapping features.}
\usage{
feature_sim(x, y, features = character(0))
}
\arguments{
\item{x}{a (\code{fem-class}) feature embedding matrix.}

\item{y}{a (\code{fem-class}) feature embedding matrix.}

\item{features}{(character) vector of features for which to compute
similarity scores. If not defined then all overlapping features will be used.}
}
\value{
a \code{data.frame} with following columns:
\describe{
\item{\code{feature}}{(character) overlapping features}
\item{\code{value}}{(numeric) cosine similarity between overlapping features.}
}
}
\description{
Efficient way of comparing two corpora along many features simultaneously.
}
\examples{
\dontrun{
# example exceeds CRAN CPU time to elapsed time limit

library(quanteda)
# tokenize corpus
toks <- tokens(cr_sample_corpus)

# create feature co-occurrence matrix for each party (set tri = FALSE to work with fem)
fcm_D <- fcm(toks[docvars(toks, 'party') == "D",],
context = "window", window = 6, count = "frequency", tri = FALSE)
fcm_R <- fcm(toks[docvars(toks, 'party') == "R",],
context = "window", window = 6, count = "frequency", tri = FALSE)

# compute feature-embedding matrix
fem_D <- fem(fcm_D, pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform, verbose = FALSE)
fem_R <- fem(fcm_R, pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform, verbose = FALSE)

# compare "horizontal" cosine similarity
feat_comp <- feature_sim(x = fem_R, y = fem_D)
}
}
\keyword{feature_sim}
