% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMatrix.R
\name{CMIBiCondimat2vec}
\alias{CMIBiCondimat2vec}
\title{Normalized Conditional Mutual Information Between Matrix and Vector Given Two Conditions}
\usage{
CMIBiCondimat2vec(mat, vec, condi1, condi2, bin = 6, sp_order = 2)
}
\arguments{
\item{mat}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{vec}{A numeric vector, with length equal to the number of columns in `mat`.}

\item{condi1}{A numeric condition vector, matching the number of columns in `mat`.}

\item{condi2}{Another numeric condition vector, matching the number of columns in `mat`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric vector representing the normalized conditional mutual information (CMI) between each row of `mat` and `vec`, given `condi1` and `condi2`.
}
\description{
Computes the normalized conditional mutual information (CMI) between each row of a matrix and a vector,
given two condition vectors, normalized by the mutual information of the vector with itself using the specified bins and spline order.
}
\examples{
mat <- matrix(rnorm(10000), nrow = 100, ncol = 100)
vec <- rnorm(100)
condi1 <- rnorm(100)
condi2 <- rnorm(100)
CMIBiCondimat2vec(mat, vec, condi1, condi2)

}
