% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_annealing.R
\name{sim_anneal}
\alias{sim_anneal}
\title{Simulated Annealing Solver}
\usage{
sim_anneal(
  temp_init = 10,
  cooling_rate = 0.95,
  max_iter = 1000L,
  neighbor_sd = 1,
  min_temp = 1e-10,
  verbose = FALSE
)
}
\arguments{
\item{temp_init}{Initial temperature (higher = more exploration)}

\item{cooling_rate}{Temperature reduction factor per iteration (0 < r < 1)}

\item{max_iter}{Maximum number of iterations}

\item{neighbor_sd}{Standard deviation for generating neighbor proposals}

\item{min_temp}{Minimum temperature before stopping}

\item{verbose}{Logical; if TRUE and the \pkg{cli} package is installed,
display progress during optimization. Default is FALSE.}
}
\value{
A solver function with signature (problem, theta0, trace) -> mle_result
}
\description{
Creates a solver using simulated annealing for global optimization.
Simulated annealing can escape local optima by probabilistically accepting
worse solutions, with the acceptance probability decreasing over time
(controlled by a "temperature" parameter).
}
\details{
At each iteration:
1. Generate a neighbor by adding Gaussian noise to current parameters
2. If the neighbor improves the objective, accept it
3. If the neighbor is worse, accept with probability exp(delta / temp)
4. Reduce temperature: temp = temp * cooling_rate

The algorithm is stochastic and may find different solutions on different runs.
For best results, use with \code{with_restarts()} or combine with a local
optimizer via \code{\%>>\%}.
}
\examples{
# Basic simulated annealing
solver <- sim_anneal()

# More exploration (higher initial temp, slower cooling)
solver <- sim_anneal(temp_init = 100, cooling_rate = 0.999)

# Coarse global search, then local refinement
strategy <- sim_anneal(max_iter = 500) \%>>\% gradient_ascent()

}
\seealso{
\code{\link{with_restarts}} for multi-start optimization,
  \code{\link{gradient_ascent}} for local refinement
}
