% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODEs.R
\name{BVPlinshoot2}
\alias{BVPlinshoot2}
\title{Linear shooting method for second-order linear BVPs}
\usage{
BVPlinshoot2(f, t0, tf, y0, yf, h, ...)
}
\arguments{
\item{f}{A function of the form \eqn{f(t,y,y')} representing 
the second-order ODE: \eqn{y''=f(t,y,y')}.}

\item{t0}{Initial time.}

\item{tf}{Final time.}

\item{y0}{Boundary value at \code{t0}, i.e. \eqn{y(t_0) = y_0}.}

\item{yf}{Boundary value at \code{tf}, i.e. \eqn{y(t_f) = y_f}.}

\item{h}{Step size.}

\item{...}{Optional parameters passed to the gradient function 
\code{f}.}
}
\value{
A list with elements \code{t} (time points) and \code{y} 
        (solution matrix). The first column of matrix \code{y} is
        the solution, \eqn{y(t)}, the second is its first derivative,
        \eqn{y'(t)}.
}
\description{
Solves a second-order linear boundary value problem using the linear
shooting method and superposition of two initial value problems.
}
\details{
If the solution of the associated homogeneous IVP is very small (close
to zero) at the second boundary (tf), the solution becomes unstable and
the function stops with a warning. Other methods must be used in those
cases.
}
\examples{

# Solve: y'' - (3/x)y' + (4/x^2)y = x
# with y(1) = 0, y(2) = 4*(log(2) + 1)
# Exact solution: y(x) = x^2*(log(x) - 1) + x^3

# Gradient
f <- function(x,y,dy,...) {
  (3/x)*dy-(4/x^2)*y+x
}

t0 <- 1
tf <- 2
y0 <- 0
yf <- 4*(log(2)+1)
h <- 0.01

ltmp <- BVPlinshoot2(f,t0,tf,y0,yf,h)

# Checks
n <- length(ltmp$t)-1
print(c(ltmp$t[1],ltmp$t[n+1]))
print(c(ltmp$y[1,1],ltmp$y[n+1,1]))

}
