% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex2rgba.R
\name{hex2rgba}
\alias{hex2rgba}
\title{Hex code colors to rgba format}
\usage{
hex2rgba(hex, alpha = NULL)
}
\arguments{
\item{hex}{character (vector), hexcode colors (e.g. #FFFFFF)}

\item{alpha}{numeric in range (0-1), default: NULL to use full opacity or given opacity (AA) in hex (#RRGGBBAA)}
}
\value{
colors in rgba format
}
\description{
Hex code colors to rgba format
}
\examples{
colors <- colorify(5)
hex2rgba(colors)
hex2rgba(colors, alpha = .5)
colors <- gsub('FF$', 75, colors)
hex2rgba(colors)
hex2rgba(colors, alpha = .5)
}
