## ----options, include = FALSE, echo = FALSE, results = 'asis'-----------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

# Increase default figure size for all plots in this vignette
knitr::opts_chunk$set(
  fig.width = 7,   # default is 4.9
  fig.height = 5,  # default is 3.5
  dpi = 96         # better for screen readability
)

# BiocStyle::markdown() # for Bioconductor package 

## ----install_CRAN, eval=FALSE, message=FALSE, warning=FALSE-------------------
# install.packages('colorify')

## ----install_GitHub, eval=FALSE, message=FALSE, warning=FALSE-----------------
# pak::pkg_install('colorify', dependencies = TRUE, upgrade = TRUE)

## ----library, eval=TRUE, message=FALSE, warning=FALSE-------------------------
library(colorify)

## ----base_colors, eval=FALSE, message=FALSE, warning=FALSE--------------------
# grDevices::colors()

## ----colorify_basic, eval=TRUE, message=FALSE, warning=FALSE------------------
colorify(n = 10, plot = TRUE)

## ----colorify_basic_seed, eval=TRUE, message=FALSE, warning=FALSE-------------
c <- colorify(10, plot = TRUE, seed = 1337)

## ----colorify_custom_colors, eval=TRUE, message=FALSE, warning=FALSE----------
c <- colorify(colors = c("red", "white", "blue"), n = 5, plot = TRUE)

## ----colorify_named_colors, eval=TRUE, message=FALSE, warning=FALSE-----------
c <- colorify(colors = c("red", "white", "blue"), n = 5, colors_names = paste0('name', rep(1:5)), plot = TRUE)

## ----colorify_order_colors, eval=TRUE, message=FALSE, warning=FALSE-----------
# set integer for the ordering starting position
c <- colorify(colors = c("red", "white", "blue"), n = 5, order = 2, plot = TRUE)
c <- colorify(colors = c("red", "white", "blue"), n = 5, order = 3, plot = TRUE)
# negative integer inverses the order 
c <- colorify(colors = c("red", "white", "blue"), n = 5, order = -1, plot = TRUE)

## ----colorify_colors_transparency, eval=TRUE, message=FALSE, warning=FALSE----
c <- colorify(colors = c("red", "white", "blue"), n = 5, alpha = .25, plot = TRUE)

## ----colorify_available_palette, eval=TRUE, message=FALSE, warning=FALSE------
c <- colorify(colors = c("Okabe-Ito"), plot = TRUE)
# note the 10th color is generated
c <- colorify(colors = c("Okabe-Ito"), plot = TRUE, n = 10)
# note that blue and yellow are cut, as only 10 colors are requested. 
c <- colorify(colors = c("Okabe-Ito", "red", "blue", "yellow"), plot = TRUE, n = 10)

## ----colorify_color_gradients, eval=TRUE, message=FALSE, warning=FALSE--------
g1 <- colorify(colors = c("orange", "red", "white", "blue", "orange"), nn = 100, plot = TRUE)
g2 <- colorify(colors = c("pastel2"), nn = 100, plot = TRUE)

## ----colorify_plotting, eval=TRUE, message=FALSE, warning=FALSE---------------
g1 <- colorify(colors = c("orange", "red", "white", "blue", "orange"), nn = 15, plot = 'l')
g1 <- colorify(colors = c("orange", "red", "white", "blue", "orange"), nn = 15, plot = 'i')
g1 <- colorify(colors = c("orange", "red", "white", "blue", "orange"), nn = 15, plot = 'il')

## ----colorify_values_and_factors, eval=TRUE, message=FALSE, warning=FALSE-----
g3 <- colorify(100, colors = c("viridis"), plot = T)
# r = red, f = factor: rf = 2 to multiply all red values 
g4 <- colorify(100, colors = c("viridis"), rf = 2, plot = T)
# v = value: rv = 50 to increase all red values by 50, on a scale between 0-100
g5 <- colorify(100, colors = c("viridis"), rv = 50, plot = T)
# first, multiply red values by 2, then increase red values by 50
g6 <- colorify(100, colors = c("viridis"), rf = 2, rv = 50, plot = T)
# first, increase red values by 50, then multiply red values by 2
g7 <- colorify(100, colors = c("viridis"), rv = 50, rf = 2, plot = T)
# float factor decrease values by multiplication
g8 <- colorify(100, colors = c("viridis"), bf = .5, plot = T)
# negative values work to decrease values 
g9 <- colorify(100, colors = c("viridis"), bv = -100, gv = -50, plot = T)

## ----colorify_min_and_max, eval=TRUE, message=FALSE, warning=FALSE------------
g3 <- colorify(100, colors = c("viridis"), plot = T)
g8 <- colorify(100, colors = c("viridis"), bf = .5, plot = T)
# same factor decrease, yet limited by minimum value
g10 <- colorify(100, colors = c("viridis"), bf = .5, bmin = 40, plot = T)
# need factor/value change to use min/max value 
g11 <- colorify(100, colors = c("viridis"), bf = 1, bmax = 40, plot = T)
# can use them in combination
g12 <- colorify(100, colors = c("viridis"), bf = 1, bmin = 40, bmax = 40,  plot = T)

## ----colorify_color_locking, eval=TRUE, message=FALSE, warning=FALSE----------
c <- colorify(colors = c("pastel2"), nn = 30, plot = TRUE)
# lock by index
c <- colorify(colors = c("pastel2"), nn = 30, colors_lock = c(4,5,6, 10,11,12), lf = .5, plot = T)
# inverse lock by index
c <- colorify(colors = c("pastel2"), nn = 30, colors_lock = -c(4:12), lf = .5, plot = T)
# lock by patterns
c <- colorify(colors = c("pastel2"), nn = 30, colors_lock = c(TRUE, FALSE), lf = .5, plot = T)
c <- colorify(colors = c("pastel2"), nn = 30, colors_lock = c(TRUE, FALSE, FALSE), lf = .5, plot = T)

## ----colorify_paired_gradients, eval=TRUE, message=FALSE, warning=FALSE-------
color_map <- colorify(colors = c('red', 'white', 'blue'), colors_map = c(0, 500, 1000))
# note the map is then given values to map back to the given color ranges from colors_map
m1 <- colorify(colors = color_map(0:1000), plot = T)

## ----display_basic, eval=TRUE, message=FALSE, warning=FALSE-------------------
display_palettes()

## ----display_basic_n, eval=TRUE, message=FALSE, warning=FALSE-----------------
p1 <- display_palettes(10)
# display 100 colors per palette
p2 <- display_palettes(100)

## ----display_zoomed_view, eval=TRUE, message=FALSE, warning=FALSE-------------
# display palettes by index
display_palettes(i_palettes = 50:75)
display_palettes(i_palettes = c(1,5,10,20,40,100,119))

## ----display_common, eval=TRUE, message=FALSE, warning=FALSE------------------
display_palettes(10, 'rcolorbrewer')
display_palettes(10, 'viridis')
display_palettes(10, 'rainbow') # grDevices palettes 

## ----display_border, eval=TRUE, message=FALSE, warning=FALSE------------------
display_palettes(n = 10, i_palettes = 1:10, border = TRUE)

## ----scale_colorify_ggplot2_setup, eval=FALSE, message=FALSE, warning=FALSE----
# install.packages('ggplot2')
# library(ggplot2)

## ----scale_colorify_ggplot2_color_non_discrete, eval=TRUE, message=FALSE, warning=FALSE----
dsub <- subset(ggplot2::diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub$diff <- with(dsub, sqrt(abs(x - y)) * sign(x - y))

ggplot2::ggplot(dsub, ggplot2::aes(x, y, colour = diff)) + 
  ggplot2::geom_point() + 
  scale_color_colorify(n = 4, colors = 'viridis') + 
  ggplot2::theme_bw()

## ----scale_colorify_ggplot2_color_discrete, eval=TRUE, message=FALSE, warning=FALSE----
p <- ggplot2::ggplot(mtcars, ggplot2::aes(wt, mpg))

p + ggplot2::geom_point(size = 4, ggplot2::aes(colour = factor(cyl))) +
  ggplot2::theme_bw() + 
  scale_color_colorify(discrete = TRUE, colors = c('red', 'blue', 'yellow'))

## ----scale_colorify_ggplot2_fill_non_discrete, eval=TRUE, message=FALSE, warning=FALSE----
dat <- data.frame(x = rnorm(10000), y = rnorm(10000))

ggplot2::ggplot(dat, ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_hex() + ggplot2::coord_fixed() +
  scale_fill_colorify(colors = 'viridis', n = 4) + ggplot2::theme_bw()

## ----scale_colorify_ggplot2_fill_discrete, eval=TRUE, message=FALSE, warning=FALSE----
df <- data.frame(category = c("A", "B", "C", "D"), value = c(10, 23, 15, 8))

ggplot2::ggplot(df, ggplot2::aes(x = category, y = value, fill = category)) +
  ggplot2::geom_bar(stat = "identity") + 
  scale_fill_colorify(discrete = TRUE, colors = 'viridis')


## ----colortistry, eval=TRUE, message=FALSE, warning=FALSE---------------------
colors_list <- list()
for (i in seq(100)) {
  colors_list[[i]] <- colorify(n = 100, colors = "rainbow", colors_lock = rep(c(T,F,F,F,F), 20), hf = 25/i, lf = i/20)
  if (i %% 3) colors_list[[i]] <- colorify(n = 100, colors = "rainbow", colors_lock = rep(c(F,F,T,F,F), 20), hf = 30/i, lf = i/20)
  if (i %% 4) colors_list[[i]] <- colorify(n = 100, colors = "rainbow", colors_lock = rep(c(F,F,F,T,F), 20), hf = 50/i, lf = i/40)
  if (i %% 5) colors_list[[i]] <- colorify(n = 100, colors = "rainbow", colors_lock = rep(c(F,T,F,F,F), 20), hf = 50/i, sf = i/50)
}
colortistry(colors_list)
# and with borders
colortistry(colors_list, border_color = 'black')

## ----session_info-------------------------------------------------------------
sessionInfo()

