% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_colors.R
\name{plot_colors}
\alias{plot_colors}
\title{Create treemaps of image color compositions}
\usage{
plot_colors(data, sort = "color", labels = TRUE)
}
\arguments{
\item{data}{a \code{data.frame} from a \code{get_colors} call consisting of the columns \code{col_hex}, \code{col_freq},
\code{col_share}.}

\item{sort}{specifies the sorting of the treemap rectangles. By default (\code{"color"}), the rectangles are sorted by
hex color codes, starting in the upper left corner. With (\code{"size"}) the largest rectangle is placed top left.}

\item{labels}{by default, rectangles that are sufficiently large are provided with a label. If \code{FALSE}, then no labels are
displayed.}
}
\description{
\code{plot_colors} creates a treemap of colors extracted from Windows BMP, JPEG, PNG, TIFF, and SVG format images with
   the \code{get_colors} function.
}
\examples{
# Extract all colors
pic1 <- system.file("extdata", "pic1.png", package = "colorfindr")
col <- get_colors(pic1)

# Plot image composition
plot_colors(col)

}
