% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_encoding_method.R
\name{validate_arg_encoding_method}
\alias{validate_arg_encoding_method}
\title{Check and validate argument \code{encoding_method}}
\usage{
validate_arg_encoding_method(
  encoding_method = "loo",
  overwrite = NULL,
  quiet = FALSE,
  function_name = NULL
)
}
\arguments{
\item{encoding_method}{(optional; character vector or NULL). Name of the target encoding methods. One or several of: "mean", "rank", "loo". If NULL, target encoding is ignored, and \code{df} is returned with no modification. Default: "loo"}

\item{overwrite}{(optional; logical) If TRUE, the original predictors in \code{df} are overwritten with their encoded versions, but only one encoding method, smoothing, white noise, and seed are allowed. Otherwise, encoded predictors with their descriptive names are added to \code{df}. Default: FALSE}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}
}
\value{
character
}
\description{
Internal function to validate the argument \code{encoding_method} of \code{\link[=target_encoding_lab]{target_encoding_lab()}}.
}
\examples{
x <- validate_arg_encoding_method(
  encoding_method = "wrong_method"
  )
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
