% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rFromWilcox}
\alias{rFromWilcox}
\title{Calculation based on Rosenthal's formula (1994). N stands for the \emph{number of measurements}.}
\usage{
rFromWilcox(wilcoxModel, N)
}
\arguments{
\item{wilcoxModel}{the Wilcox model}

\item{N}{number of measurements in the experiment}
}
\value{
Invisibly returns a list with components:
\itemize{
\item \code{r}: effect size as a numeric scalar.
\item \code{z}: corresponding z-statistic.
\item \code{text}: character string that is also sent to the console.
}
}
\description{
Calculation based on Rosenthal's formula (1994). N stands for the \emph{number of measurements}.
}
\examples{
set.seed(1)
d <- data.frame(
  group = rep(c("A", "B"), each = 10),
  value = rnorm(20)
)
w <- stats::wilcox.test(value ~ group, data = d, exact = FALSE)
rFromWilcox(w, N = nrow(d))
}
