% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_stroke.r
\name{draw_stroke}
\alias{draw_stroke}
\title{Visualize Stroke Region and Center of Gravity (COG)}
\usage{
draw_stroke(lst, show_cog = TRUE, plot_image = TRUE, cimg = TRUE)
}
\arguments{
\item{lst}{A list returned by \code{\link{cog_stroke}}, containing stroke pixel data
and computed statistics.}

\item{show_cog}{Logical. If \code{TRUE} (default), draws horizontal and vertical
red lines through the COG to visualize its position.}

\item{plot_image}{Logical. If \code{TRUE} (default), plots the image. If \code{FALSE},
returns the image object without plotting.}

\item{cimg}{Logical. If \code{TRUE} (default) and \pkg{imager} is available, returns
a \code{cimg} object. If \code{FALSE}, always returns a raster object.}
}
\value{
If \code{cimg = TRUE} and \pkg{imager} is installed, returns a \code{cimg}
object. Otherwise, returns a raster object (class \code{"raster"}).
}
\description{
Visualizes the stroke region of a character-like binary image using the result
from \code{\link{cog_stroke}}. Optionally overlays crosshair lines at the computed
center of gravity (COG) position.
}
\details{
By default (\code{cimg = TRUE}), the function returns a \code{cimg} object if the
\pkg{imager} package is available. If \pkg{imager} is not installed or if
\code{cimg = FALSE}, a base R raster object created by \code{as.raster()} is returned.
}
\examples{
\dontshow{if ((identical(Sys.getenv("IN_PKGDOWN"), "true") || interactive())) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(img_A)
result <- cog_stroke(img_A)
draw_stroke(result, show_cog = TRUE, cimg = FALSE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{cog_stroke}}
}
