% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog_irt.R
\name{cog_irt}
\alias{cog_irt}
\title{Fit Item Response Theory Models with Optional Contrast Effects}
\usage{
cog_irt(
  data = NULL,
  model = NULL,
  guessing = NULL,
  contrast_codes = NULL,
  num_conditions = NULL,
  num_contrasts = NULL,
  constraints = NULL,
  key = NULL,
  link = "probit",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A matrix of item responses (K by IJ). Rows should contain each
subject's dichotomous responses (1 or 0) for the items indexed by each
column.}

\item{model}{An IRT model name. The options are "1p" for the one-parameter
model, "2p" for the two parameter model, "3p" for the three-parameter model,
or "sdt" for the signal detection-weighted model.}

\item{guessing}{Either a single numeric guessing value or a matrix of item
guessing parameters (IJ by 1). This argument is only used when model = '3p'.}

\item{contrast_codes}{Either a matrix of contrast codes (JM by MN) or the
name in quotes of a R stats contrast function (i.e., "contr.helmert",
"contr.poly", "contr.sum", "contr.treatment", or "contr.SAS"). If using the R
stats contrast function items in the data matrix must be arranged by
condition.}

\item{num_conditions}{The number of conditions (required if using the R stats
contrast function or when constraints = TRUE).}

\item{num_contrasts}{The number of contrasts including intercept (required if
using the R stats contrast function or when constraints = TRUE).}

\item{constraints}{Either a logical (TRUE or FALSE) indicating that item
parameters should be constrained to be equal over the J conditions or a 1 by
I vector of items that should be constrained to be equal across conditions.}

\item{key}{An item key vector where 1 indicates target and 2 indicates
distractor (IJ). Required when model = 'sdt'.}

\item{link}{The name ("logit" or "probit") of the link function to be used in
the model.}

\item{verbose}{Logical (TRUE or FALSE) indicating whether to print progress.}

\item{...}{Additional arguments.}
}
\value{
A list with elements for all parameters estimated (omega1, nu1,
and/or lambda1), information values for all parameters estimated
(info1_omega, info1_nu, and/or info1_lambda), the model log-likelihood value
(log_lik), and the total number of estimated parameters (par) in the model.
}
\description{
This function estimates item response theory (IRT) model parameters. Users
can optionally estimate person parameters that account for experimental or
longitudinal contrast effects.
}
\section{Dimensions}{

I = Number of items per condition; J = Number of conditions or time points;
K = Number of examinees; M Number of ability (or trait) dimensions; N Number
of contrast effects (including intercept).
}

\examples{
\donttest{
nback_fit_contr <- cog_irt(data = nback$y, model = "sdt",
                           contrast_codes = "contr.poly", key = nback$key,
                           num_conditions = length(unique(nback$condition)),
                           num_contrasts = 2)
plot(nback_fit_contr)
}

}
\references{
Embretson S. E., & Reise S. P. (2000). \emph{Item response theory for
psychologists.} Mahwah, N.J.: L. Erlbaum Associates.

Thomas, M. L., Brown, G. G., Patt, V. M., & Duffy, J. R. (2021). Latent
variable modeling and adaptive testing for experimental cognitive
psychopathology research.  \emph{Educational and Psychological Measurement,
81}(1), 155-181.
}
