% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{sequence_indices}
\alias{sequence_indices}
\title{Compute Sequence Indices for Sequence Data}
\usage{
sequence_indices(data, cols, favorable, omega = 1)
}
\arguments{
\item{data}{[\code{data.frame}, \code{matrix}, \code{stslist}]\cr
Sequence data in wide format (rows are sequences, columns are time points).}

\item{cols}{[\code{expression}]\cr A tidy selection of columns that should
be considered as sequence data. By default, all columns are used.}

\item{favorable}{[\code{character()}]\cr Names of states that should be
considered as favorable states.}

\item{omega}{[\code{numeric(1)}]\cr Omega parameter value used to compute
the integrative potential.}
}
\value{
A \code{tibble} containing the index values.
}
\description{
Compute Sequence Indices for Sequence Data
}
\examples{
sequence_indices(engagement)

}
