% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micobinreg.R
\name{micobinreg}
\alias{micobinreg}
\title{micobin generalized linear (mixed) models}
\usage{
micobinreg(
  formula,
  data,
  link = "cobit",
  contrasts = NULL,
  priors = list(beta_intercept_scale = 100, beta_scale = 100, beta_df = Inf),
  nburn = 1000,
  nsave = 1000,
  nthin = 1,
  psi_fixed = NULL
)
}
\arguments{
\item{formula}{an object of class "\link[stats]{formula}" or a two-sided linear formula object describing both the fixed-effects and random-effects part of the model; see "\link[lme4]{lmer}"}

\item{data}{data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model.}

\item{link}{character, link function (default "cobit"). Only supports canonical link function "cobit" that is compatible with Kolmogorov-Gamma augmentation.}

\item{contrasts}{an optional list. See the contrasts.arg of \link[stats]{model.matrix.default}.}

\item{priors}{a list of prior hyperparameters. See Details}

\item{nburn}{number of burn-in MCMC iterations.}

\item{nsave}{number of posterior samples. Total MCMC iteration is nburn + nsave*nthin}

\item{nthin}{thin-in rate. Total MCMC iteration is nburn + nsave*nthin}

\item{psi_fixed}{logical, fixing psi; experimental}
}
\value{
Returns list of
\item{post_save}{a matrix of posterior samples (coda::mcmc) with nsave rows}
\item{loglik_save}{a nsave x n matrix of pointwise log-likelihood values, can be used for WAIC calculation.}
\item{priors}{list of hyperprior information}
\item{nsave}{number of MCMC samples}
\item{t_mcmc}{wall-clock time for running MCMC}
\item{t_premcmc}{wall-clock time for preprocessing before MCMC}
\item{y}{response vector}
\item{X}{fixed effect design matrix}
if random effect model, also returns
\item{post_u_save}{a matrix of posterior samples (coda::mcmc) of random effects}
\item{Z}{random effect design matrix}
}
\description{
Fit Bayesian micobin regression model under canonical link (cobit link) with Markov chain Monte Carlo (MCMC).
It supports both fixed-effect only model
\deqn{
 y_i \mid x_i \stackrel{ind}{\sim} micobin(x_i^T\beta, \psi),
}
for \eqn{i=1,\dots,n}, and random intercept model (v 1.0.x only supports random intercept),
\deqn{
 y_{ij} \mid x_{ij}, u_i \stackrel{ind}{\sim} micobin(x_{ij}^T\beta + u_i, \psi), \quad u_i\stackrel{iid}{\sim} N(0, \sigma_u^2)
}
for \eqn{i=1,\dots,n} (group), and \eqn{j=1,\dots,n_i} (observation within group). See \link[cobin]{dmicobin} for details on micobin distribution.
}
\details{
The prior setting can be controlled with "priors" argument.
Prior for regression coefficients are independent normal or t prior centered at 0.
"priors" is a named list of:
\itemize{
\item beta_intercept_scale, Default 100, the scale of the intercept prior
\item beta_scale, Default 100, the scale of nonintercept fixed-effect coefficients
\item beta_df, Default Inf, degree of freedom of t prior. If \code{beta_df=Inf}, it corresponds to normal prior
\item lambda_max, Default 70, upper bound for lambda (integer)
\item psi_ab, Default c(2,2), beta shape parameters for \eqn{\psi} (length 2 vector).
}
if random intercept model, u ~ InvGamma(a_u,b_u) with
\itemize{
\item a_u, Default 1, first parameter of Inverse Gamma prior of u
\item b_u, Default 1, second parameter of Inverse Gamma prior of u
}
}
\examples{
\donttest{
requireNamespace("betareg", quietly = TRUE)
library(betareg)# for dataset example
data("GasolineYield", package = "betareg")

# basic model 
out1 = micobinreg(yield ~ temp, data = GasolineYield, 
               nsave = 2000, link = "cobit")
summary(out1$post_save)
plot(out1$post_save)

# random intercept model
out2 = micobinreg(yield ~ temp + (1 | batch), data = GasolineYield, 
               nsave = 2000, link = "cobit")
summary(out2$post_save)
plot(out2$post_save)
}
}
