% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudml-package.R
\docType{package}
\name{cloudml-package}
\alias{cloudml-package}
\alias{cloudml}
\title{Interface to the Google Cloud Machine Learning Platform}
\description{
The \strong{cloudml} package provides an R interface to \href{https://cloud.google.com/vertex-ai}{Google Cloud Machine Learning Engine}, a managed service that
enables:
\itemize{
\item Scalable training of models built with the
\href{https://keras3.posit.co/}{keras},
\href{https://github.com/rstudio/tfestimators}{tfestimators}, and
\href{https://tensorflow.rstudio.com/}{tensorflow} R packages.
\item On-demand access to training on GPUs, including the new \href{https://www.nvidia.com/en-us/data-center/}{Tesla P100 GPUs} from NVIDIA®.
\item Hyperparameter tuning to optimize key attributes of model architectures in
order to maximize predictive accuracy.
\item Deployment of trained models to the Google global prediction platform that
can support thousands of users and TBs of data.
}
}
\details{
CloudML is a managed service where you pay only for the hardware resources
that you use. Prices vary depending on configuration (e.g. CPU vs. GPU vs.
multiple GPUs). See \url{https://cloud.google.com/vertex-ai/pricing} for
additional details.

For documentation on using the R interface to CloudML see the package website
at \url{https://github.com/rstudio/cloudml}
}
\references{
\url{https://github.com/rstudio/cloudml}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/rstudio/cloudml}
  \item Report bugs at \url{https://github.com/rstudio/cloudml/issues}
}

}
\author{
\strong{Maintainer}: Tomasz Kalinowski \email{tomasz@posit.co}

Authors:
\itemize{
  \item Daniel Falbel \email{daniel@rstudio.com}
  \item Javier Luraschi
  \item JJ Allaire
  \item Kevin Ushey
}

Other contributors:
\itemize{
  \item  RStudio [copyright holder]
}

}
\keyword{internal}
