\name{trunk_impairment_scale}
\alias{trunk_impairment_scale}
\title{
Trunk Impairment Scale (TIS)
}
\description{
Calculates the Trunk Impairment Scale (TIS) score, a tool used to evaluate motor impairment of the trunk after stroke. The scale assesses static sitting balance, dynamic sitting balance, and trunk coordination. The total score ranges from 0 to 23, with higher scores indicating better trunk performance.
}
\usage{
trunk_impairment_scale(static_sitting_balance, dynamic_sitting_balance,
                       coordination)
}
\arguments{
  \item{static_sitting_balance}{
Numeric (0-7). Score for static sitting balance. Includes items like ability to sit without support and maintain position.
}
  \item{dynamic_sitting_balance}{
Numeric (0-10). Score for dynamic sitting balance. Includes items like touching the bed/mat with the elbow (lateral flexion) initiated from the upper and lower trunk.
}
  \item{coordination}{
Numeric (0-6). Score for trunk coordination. Includes items like rotation of the shoulder girdle and pelvic girdle.
}
}
\value{
A list containing:
\item{TIS_Total_Score}{The calculated total score (Range 0-23).}
\item{Interpretation}{General interpretation of the score.}
\item{Subscale_Scores}{Breakdown of scores for each subscale.}
}
\references{
Verheyden G, Nieuwboer A, Mertin J, et al. The Trunk Impairment Scale: a new tool to measure motor impairment of the trunk after stroke. Clin Rehabil. 2004;18(3):326-334. doi:10.1191/0269215504cr733oa
}
\examples{

# Example 1: Moderate Impairment
# Static: 5/7, Dynamic: 4/10, Coordination: 2/6
# Total = 11
trunk_impairment_scale(5, 4, 2)

# Example 2: Minimal Impairment
# Static: 7/7, Dynamic: 9/10, Coordination: 5/6
# Total = 21
trunk_impairment_scale(7, 9, 5)
}
