\name{sodium_correction_rate}
\alias{sodium_correction_rate}
\title{
Sodium Correction Rate in Hyponatremia/Hypernatremia (Adrogue-Madias)
}
\description{
Calculates the infusion rate of a selected fluid required to correct serum sodium to a target level over a specified time. Uses the Adrogue-Madias formula to estimate the change in serum sodium per liter of infusate.
}
\usage{
sodium_correction_rate(current_sodium, target_sodium, time_hours,
                       fluid_sodium, weight_kg, percent_body_water = 0.5)
}
\arguments{
  \item{current_sodium}{
Numeric. Current serum sodium level (mEq/L).
}
  \item{target_sodium}{
Numeric. Desired target serum sodium level (mEq/L).
}
  \item{time_hours}{
Numeric. Duration over which to achieve the target (hours).
}
  \item{fluid_sodium}{
Numeric. Sodium content of the infusate (mEq/L). (e.g., 3\% NaCl = 513, 0.9\% NaCl = 154, D5W = 0).
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{percent_body_water}{
Numeric. Fraction of total body water (e.g., 0.6 for men, 0.5 for women/elderly men, 0.45 for elderly women). Defaults to 0.5.
}
}
\details{
The formula for the change in serum Na per liter of fluid is:
\deqn{\Delta Na = \frac{Fluid Na - Serum Na}{TBW + 1}}
The volume required is:
\deqn{Volume (L) = \frac{Target Na - Current Na}{\Delta Na}}
}
\value{
A list containing:
\item{Infusion_Rate_mL_hr}{The calculated infusion rate in mL/hr.}
\item{Total_Volume_L}{Total volume required to reach target.}
\item{Change_In_Serum_Na_per_L_Infusate}{Estimated change in serum Na for every 1L infused.}
}
\references{
Adrogue HJ, Madias NE. Hyponatremia. N Engl J Med. 2000;342(21):1581-1589. doi:10.1056/NEJM200005253422107
}
\examples{

# Example 1: Hyponatremia correction
# Na 115 -> 120 in 24h, using 3% Saline (513 mEq/L), 70kg Male (0.6 TBW)
sodium_correction_rate(115, 120, 24, 513, 70, 0.6)

# Example 2: Hypernatremia correction
# Na 155 -> 150 in 24h, using D5W (0 mEq/L), 60kg Elderly Woman (0.45 TBW)
sodium_correction_rate(155, 150, 24, 0, 60, 0.45)
}
