\name{rose_syncope_score}
\alias{rose_syncope_score}
\title{
ROSE Risk Stratification of Syncope
}
\description{
Applies the ROSE (Risk Stratification of Syncope in the Emergency Department) rule to predict serious outcomes at 1 month in patients presenting with syncope. The rule uses the mnemonic **BRACES** to identify high-risk features (BNP, Bradycardia, Rectal exam/FOBT, Anemia, Chest pain, ECG Q-waves, Saturation). The presence of any single risk factor classifies the patient as High Risk.
}
\usage{
rose_syncope_score(bnp_level, heart_rate, positive_fecal_occult_blood,
                   hemoglobin, chest_pain, ecg_q_waves, oxygen_saturation)
}
\arguments{
  \item{bnp_level}{
Numeric. B-Type Natriuretic Peptide level in pg/mL. (>= 300 indicates high risk).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (<= 50 indicates high risk).
}
  \item{positive_fecal_occult_blood}{
Numeric (0 or 1). Positive rectal exam for fecal occult blood? (1 = Yes).
}
  \item{hemoglobin}{
Numeric. Hemoglobin level in g/dL. (<= 9.0 g/dL indicates high risk).
}
  \item{chest_pain}{
Numeric (0 or 1). Did the patient experience chest pain associated with the syncope? (1 = Yes).
}
  \item{ecg_q_waves}{
Numeric (0 or 1). Are pathological Q waves present on ECG (excluding lead III)? (1 = Yes).
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation on room air percentage. (<= 94\% indicates high risk).
}
}
\value{
A list containing:
\item{Risk_Category}{"Low Risk" (0 factors) or "High Risk" (>= 1 factor).}
\item{Recommendation}{Clinical guidance regarding discharge vs. admission.}
\item{Risk_Factors_Present}{A list of the specific criteria met.}
}
\references{
Reed MJ, Newby DE, Coull AJ, et al. The ROSE (Risk Stratification of Syncope in the Emergency Department) study. J Am Coll Cardiol. 2010;55(8):713-721. doi:10.1016/j.jacc.2009.09.049
}
\examples{

# Example 1: High Risk
# BNP 400, HR 45, SpO2 92
# Result: High Risk (BNP, Bradycardia, Saturation)
rose_syncope_score(400, 45, 0, 12.0, 0, 0, 92)

# Example 2: Low Risk
# Normal labs and vitals
# Result: Low Risk
rose_syncope_score(50, 70, 0, 14.0, 0, 0, 98)
}
