\name{ripasa_appendicitis_score}
\alias{ripasa_appendicitis_score}
\title{
RIPASA Score for Acute Appendicitis
}
\description{
Calculates the RIPASA score, a diagnostic scoring system developed to improve the sensitivity and specificity of diagnosing acute appendicitis, particularly in Asian and Middle Eastern populations compared to the Alvarado score. It utilizes 15 clinical and demographic parameters.
}
\usage{
ripasa_appendicitis_score(sex, age, rif_pain, pain_migration, anorexia,
                          nausea_vomiting, symptom_duration_lt_48h, rif_tenderness,
                          guarding, rebound_tenderness, rovsing_sign, fever,
                          elevated_wbc, negative_urinalysis, foreign_national)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male +1, Female +0.5).
}
  \item{age}{
Numeric. Patient age in years. (<40y +1, >=40y +0.5).
}
  \item{rif_pain}{
Numeric (0 or 1). Pain in the Right Iliac Fossa. (1 = Yes, +0.5).
}
  \item{pain_migration}{
Numeric (0 or 1). Migration of pain to the RIF. (1 = Yes, +0.5).
}
  \item{anorexia}{
Numeric (0 or 1). Anorexia. (1 = Yes, +1).
}
  \item{nausea_vomiting}{
Numeric (0 or 1). Nausea and/or vomiting. (1 = Yes, +1).
}
  \item{symptom_duration_lt_48h}{
Numeric (0 or 1). Duration of symptoms less than 48 hours. (1 = Yes, +1; 0 (>48h) = +0.5).
}
  \item{rif_tenderness}{
Numeric (0 or 1). Tenderness in the RIF. (1 = Yes, +1).
}
  \item{guarding}{
Numeric (0 or 1). Guarding in the RIF. (1 = Yes, +2).
}
  \item{rebound_tenderness}{
Numeric (0 or 1). Rebound tenderness. (1 = Yes, +1).
}
  \item{rovsing_sign}{
Numeric (0 or 1). Positive Rovsing's sign. (1 = Yes, +2).
}
  \item{fever}{
Numeric (0 or 1). Fever (typically > 37.5C or 99.5F). (1 = Yes, +1).
}
  \item{elevated_wbc}{
Numeric (0 or 1). Elevated White Blood Cell count. (1 = Yes, +1).
}
  \item{negative_urinalysis}{
Numeric (0 or 1). Negative urinalysis (absence of blood/nitrites/leukocytes). (1 = Yes, +1).
}
  \item{foreign_national}{
Numeric (0 or 1). Is the patient a foreign national (relative to the derivation setting, e.g., foreign NRIC)? (1 = Yes, +1).
}
}
\value{
A list containing:
\item{RIPASA_Score}{The calculated total score.}
\item{Appendicitis_Probability}{Estimated likelihood category (Unlikely, Low, High, Definite).}
\item{Recommendation}{Suggested management plan.}
}
\references{
Chong CF, Adi MI, Thien A, et al. Development of the RIPASA score: a new appendicitis scoring system for the diagnosis of acute appendicitis. Singapore Med J. 2010;51(3):220-225.
}
\examples{

# Example 1: High Probability
# Male (+1), 30y (+1), RIF Pain (+0.5), Migration (+0.5), Guarding (+2), Rebound (+1), High WBC (+1)
# Score = 7.0
ripasa_appendicitis_score("male", 30, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0)

# Example 2: Definite Appendicitis
# Male, 25y, All signs positive except foreign national
# Score > 12
ripasa_appendicitis_score("male", 25, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0)
}
