\name{padua_vte_score}
\alias{padua_vte_score}
\title{
Padua Prediction Score for Risk of VTE
}
\description{
Calculates the Padua Prediction Score to assess the risk of Venous Thromboembolism (VTE) in hospitalized medical patients. The score stratifies patients into low or high risk categories to guide thromboprophylaxis decisions.
}
\usage{
padua_vte_score(active_cancer, previous_vte, reduced_mobility,
                known_thrombophilia, recent_trauma_surgery, age,
                heart_respiratory_failure, acute_mi_stroke,
                infection_rheumatologic, bmi, hormonal_treatment)
}
\arguments{
  \item{active_cancer}{
Numeric (0 or 1). Active cancer (metastases and/or chemo/radiation in last 6 months). (1 = Yes, +3 points).
}
  \item{previous_vte}{
Numeric (0 or 1). Previous VTE (excluding superficial vein thrombosis). (1 = Yes, +3 points).
}
  \item{reduced_mobility}{
Numeric (0 or 1). Reduced mobility (bedrest with bathroom privileges for >= 3 days). (1 = Yes, +3 points).
}
  \item{known_thrombophilia}{
Numeric (0 or 1). Known thrombophilic condition. (1 = Yes, +3 points).
}
  \item{recent_trauma_surgery}{
Numeric (0 or 1). Recent (<= 1 month) trauma or surgery. (1 = Yes, +2 points).
}
  \item{age}{
Numeric. Patient age in years. (>= 70 years adds 1 point).
}
  \item{heart_respiratory_failure}{
Numeric (0 or 1). Heart or respiratory failure. (1 = Yes, +1 point).
}
  \item{acute_mi_stroke}{
Numeric (0 or 1). Acute myocardial infarction or ischemic stroke. (1 = Yes, +1 point).
}
  \item{infection_rheumatologic}{
Numeric (0 or 1). Acute infection or rheumatologic disorder. (1 = Yes, +1 point).
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2). (>= 30 adds 1 point).
}
  \item{hormonal_treatment}{
Numeric (0 or 1). Ongoing hormonal treatment. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Padua_Score}{The calculated total score (Range 0-20).}
\item{Risk_Category}{Classification (Low Risk < 4, High Risk >= 4).}
\item{Recommendation}{Clinical guidance regarding prophylaxis.}
}
\references{
Barbar S, Noventa F, Rossetto V, et al. A risk assessment model for the identification of hospitalized medical patients at risk for venous thromboembolism: the Padua Prediction Score. J Thromb Haemost. 2010;8(11):2450-2457. doi:10.1111/j.1538-7836.2010.04044.x
}
\examples{

# Example 1: High Risk
# Cancer (+3), Recent Surgery (+2), Age 75 (+1)
# Score = 6
padua_vte_score(1, 0, 0, 0, 1, 75, 0, 0, 0, 25, 0)

# Example 2: Low Risk
# Infection (+1), BMI 32 (+1), Age 50 (0)
# Score = 2
padua_vte_score(0, 0, 0, 0, 0, 50, 0, 0, 1, 32, 0)
}
