\name{opioid_risk_tool}
\alias{opioid_risk_tool}
\title{
Opioid Risk Tool (ORT) for Narcotic Abuse
}
\description{
Calculates the Opioid Risk Tool (ORT) score to predict the probability of a patient displaying aberrant behaviors when prescribed opioids for chronic pain. The scoring algorithm assigns different point values to risk factors depending on the patient's sex.
}
\usage{
opioid_risk_tool(sex, age, family_hx_alcohol, family_hx_illegal, family_hx_rx,
                 personal_hx_alcohol, personal_hx_illegal, personal_hx_rx,
                 history_sexual_abuse, psych_disease_adhd_ocd_bipolar_schizo,
                 psych_disease_depression)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years. (Age 16-45 adds 1 point for both sexes).
}
  \item{family_hx_alcohol}{
Numeric (0 or 1). Family history of alcohol abuse. (Female: +1, Male: +3).
}
  \item{family_hx_illegal}{
Numeric (0 or 1). Family history of illegal drug abuse. (Female: +2, Male: +3).
}
  \item{family_hx_rx}{
Numeric (0 or 1). Family history of prescription drug abuse. (Female: +4, Male: +4).
}
  \item{personal_hx_alcohol}{
Numeric (0 or 1). Personal history of alcohol abuse. (Female: +3, Male: +3).
}
  \item{personal_hx_illegal}{
Numeric (0 or 1). Personal history of illegal drug abuse. (Female: +4, Male: +4).
}
  \item{personal_hx_rx}{
Numeric (0 or 1). Personal history of prescription drug abuse. (Female: +5, Male: +5).
}
  \item{history_sexual_abuse}{
Numeric (0 or 1). History of preadolescent sexual abuse. (Female: +3, Male: 0).
}
  \item{psych_disease_adhd_ocd_bipolar_schizo}{
Numeric (0 or 1). Psychological disease (ADD, OCD, Bipolar, Schizophrenia). (Female: +2, Male: +2).
}
  \item{psych_disease_depression}{
Numeric (0 or 1). Psychological disease (Depression). (Female: +1, Male: +1).
}
}
\value{
A list containing:
\item{ORT_Score}{The calculated total score (Range 0-26).}
\item{Risk_Category}{Classification (Low <= 3, Moderate 4-7, High >= 8).}
}
\references{
Webster LR, Webster RM. Predicting aberrant behaviors in opioid-treated patients: preliminary validation of the Opioid Risk Tool. Pain Med. 2005;6(6):432-442. doi:10.1111/j.1526-4637.2005.00072.x
}
\examples{

# Example 1: High Risk Male
# Fam Hx Alcohol (+3), Pers Hx Illegal (+4), Age 30 (+1)
# Score = 8
opioid_risk_tool("male", 30, 1, 0, 0, 0, 1, 0, 0, 0, 0)

# Example 2: Moderate Risk Female
# Fam Hx Alcohol (+1), Hx Sexual Abuse (+3)
# Score = 4
opioid_risk_tool("female", 50, 1, 0, 0, 0, 0, 0, 1, 0, 0)
}
