\name{nrpe_diuretic_response}
\alias{nrpe_diuretic_response}
\title{
Natriuretic Response Prediction Equation (NRPE)
}
\description{
Calculates the predicted 6-hour cumulative sodium output based on a single spot urine sodium sample taken 2 hours after loop diuretic administration. This tool helps evaluate diuretic resistance and guide titration in patients with acute heart failure.
}
\usage{
nrpe_diuretic_response(spot_urine_sodium)
}
\arguments{
  \item{spot_urine_sodium}{
Numeric. Spot urine sodium concentration (mmol/L or mEq/L) measured 2 hours after diuretic administration.
}
}
\value{
A list containing:
\item{Predicted_6hr_Sodium_Output_mmol}{The estimated total sodium excretion over 6 hours.}
\item{Interpretation}{Assessment of response adequacy based on the common threshold of 50 mmol/L.}
}
\references{
Rao VS, Ivey-Miranda JB, Cox ZL, et al. Natriuretic Equation to Predict Loop Diuretic Response in Patients With Heart Failure. J Am Coll Cardiol. 2019;74(7):861-868. doi:10.1016/j.jacc.2019.06.028
}
\examples{

# Example 1: Poor Response
# Spot Na 30 mmol/L
nrpe_diuretic_response(30)

# Example 2: Good Response
# Spot Na 100 mmol/L
nrpe_diuretic_response(100)
}
