\name{naloxone_drip_dosing}
\alias{naloxone_drip_dosing}
\title{
Naloxone Drip Dosing
}
\description{
Calculates the recommended hourly infusion rate for a naloxone drip. This is indicated for patients with opioid intoxication who require repeat bolus doses or have ingested long-acting opioids (e.g., methadone). The standard toxicology rule of thumb is to set the hourly infusion rate at 2/3 of the effective "wake-up" bolus dose.
}
\usage{
naloxone_drip_dosing(wake_up_bolus_mg)
}
\arguments{
  \item{wake_up_bolus_mg}{
Numeric. The total bolus dose of naloxone (in mg) required to reverse respiratory depression (the "wake-up" dose).
}
}
\value{
A list containing:
\item{Calculated_Hourly_Rate_mg_hr}{The calculated continuous infusion rate in mg/hr.}
\item{Protocol_Note}{Guidance on the 2/3 rule.}
}
\references{
Goldfrank LR. Goldfrank's Toxicologic Emergencies. 11th ed. New York, NY: McGraw-Hill Education; 2019.
Clarke SF, Dargan PI, Jones AL. Naloxone in opioid poisoning: walking the tightrope. Emerg Med J. 2005;22(9):612-616. doi:10.1136/emj.2003.009613
}
\examples{

# Example 1: 0.4 mg reversed the patient
# Rate = 0.4 * (2/3) = 0.27 mg/hr
naloxone_drip_dosing(0.4)

# Example 2: High dose required (2 mg)
# Rate = 2 * (2/3) = 1.33 mg/hr
naloxone_drip_dosing(2.0)
}
