\name{marburg_heart_score}
\alias{marburg_heart_score}
\title{
Marburg Heart Score (MHS)
}
\description{
Calculates the Marburg Heart Score to rule out coronary artery disease (CAD) in primary care patients presenting with chest pain. The score stratifies patients into low, intermediate, or high probability of having significant CAD based on five clinical predictors.
}
\usage{
marburg_heart_score(age, sex, history_vascular_disease, patient_suspects_cardiac,
                    pain_worsens_exercise, pain_not_reproducible)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Score adds 1 point if Male >= 55 or Female >= 65).
}
  \item{history_vascular_disease}{
Numeric (0 or 1). Known atherosclerosis, including Coronary Artery Disease, Cerebrovascular Disease, or Peripheral Arterial Disease. (1 = Yes, +1 point).
}
  \item{patient_suspects_cardiac}{
Numeric (0 or 1). Does the patient assume the pain is of cardiac origin? (1 = Yes, +1 point).
}
  \item{pain_worsens_exercise}{
Numeric (0 or 1). Does the pain worsen with exercise? (1 = Yes, +1 point).
}
  \item{pain_not_reproducible}{
Numeric (0 or 1). Is the pain NOT reproducible by palpation? (1 = Yes/Not Reproducible, +1 point. Note: If pain IS reproducible, enter 0).
}
}
\value{
A list containing:
\item{MHS_Score}{The calculated score (Range 0-5).}
\item{Risk_Category}{Classification (Low 0-2, Intermediate 3, High 4-5).}
\item{CAD_Probability}{Estimated probability of significant Coronary Artery Disease.}
}
\references{
Bosner S, Becker A, Haasenritter J, et al. Chest pain in primary care: epidemiology and pre-work-up probabilities. Eur J Gen Pract. 2009;15(3):141-146.
Haasenritter J, Bösner S, Vaucher P, et al. Ruling out coronary heart disease in primary care: external validation of a clinical prediction rule. CMAJ. 2012;184(3):E149-E157. doi:10.1503/cmaj.110960
}
\examples{

# Example 1: High Risk
# 60yo Male (+1), Vascular Hx (+1), Suspects Cardiac (+1), Exertional (+1), Not Reproducible (+1)
# Score = 5
marburg_heart_score(60, "male", 1, 1, 1, 1)

# Example 2: Low Risk
# 40yo Female (0), No Hx, Reproducible pain (Input 0 for 'not reproducible')
# Score = 0
marburg_heart_score(40, "female", 0, 0, 0, 0)
}
