\name{iss_multiple_myeloma}
\alias{iss_multiple_myeloma}
\title{
International Staging System (ISS) for Multiple Myeloma
}
\description{
Calculates the International Staging System (ISS) stage for multiple myeloma. This system stratifies patients into three prognostic groups based on serum beta-2 microglobulin and serum albumin levels.
}
\usage{
iss_multiple_myeloma(beta2_microglobulin, albumin)
}
\arguments{
  \item{beta2_microglobulin}{
Numeric. Serum Beta-2 Microglobulin level in mg/L.
}
  \item{albumin}{
Numeric. Serum Albumin level in g/dL.
}
}
\value{
A list containing:
\item{ISS_Stage}{The calculated stage (I, II, or III).}
\item{Median_Overall_Survival}{Estimated median overall survival based on the original study data.}
}
\references{
Greipp PR, San Miguel J, Durie BG, et al. International staging system for multiple myeloma. J Clin Oncol. 2005;23(15):3412-3420. doi:10.1200/JCO.2005.04.242
}
\examples{

# Example 1: Stage I (Low B2M, Normal Albumin)
# B2M 2.5, Alb 4.0
iss_multiple_myeloma(2.5, 4.0)

# Example 2: Stage III (High B2M)
# B2M 6.0, Alb 3.0
iss_multiple_myeloma(6.0, 3.0)

# Example 3: Stage II (Intermediate)
# B2M 4.0 (Between 3.5 and 5.5)
iss_multiple_myeloma(4.0, 3.5)
}
