\name{intraoperative_fluid_dosing}
\alias{intraoperative_fluid_dosing}
\title{
Intraoperative Fluid Dosing for Adult Patients
}
\description{
Calculates the recommended intraoperative fluid dosing for adult patients (>= 20 kg) based on the standard 4-2-1 rule for maintenance, NPO deficit replacement (50/25/25 rule), and third-space losses estimated by surgical trauma severity.
}
\usage{
intraoperative_fluid_dosing(weight_kg, npo_time_hours, trauma_severity)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{npo_time_hours}{
Numeric. Time spent NPO (nothing by mouth) in hours prior to surgery.
}
  \item{trauma_severity}{
String. Estimated severity of surgical trauma. Options: "minimal" (e.g., hernia), "moderate" (e.g., cholecystectomy), "severe" (e.g., bowel resection). Note: Minimal is calculated at 2 mL/kg/hr, Moderate at 4 mL/kg/hr, and Severe at 6 mL/kg/hr for third-space losses.
}
}
\value{
A list containing:
\item{Maintenance_Rate_mL_hr}{The calculated hourly maintenance fluid rate.}
\item{Fluid_Deficit_Total_mL}{The total fluid deficit accumulated during NPO time.}
\item{Third_Space_Loss_mL_hr}{The estimated hourly fluid loss due to surgical trauma/third-spacing.}
\item{Hourly_Rates}{A list of recommended infusion rates (mL/hr) for the 1st, 2nd, 3rd, and subsequent hours of surgery.}
}
\references{
Holliday MA, Segar WE. The maintenance need for water in parenteral fluid therapy. Pediatrics. 1957;19(5):823-832.
Miller RD. Miller's Anesthesia. 8th ed. Philadelphia, PA: Elsevier Saunders; 2015.
}
\examples{

# Example 1: 70kg patient, NPO 8 hours, Moderate Trauma
# Maintenance: 40 + 20 + 50 = 110 mL/hr
# Deficit: 110 * 8 = 880 mL
# Third Space: 4 * 70 = 280 mL/hr
# Hour 1: 110 + 440 + 280 = 830 mL/hr
intraoperative_fluid_dosing(70, 8, "moderate")

# Example 2: 100kg patient, NPO 10 hours, Severe Trauma
intraoperative_fluid_dosing(100, 10, "severe")
}
