\name{gwtg_hf_risk_score}
\alias{gwtg_hf_risk_score}
\title{
GWTG-HF Risk Score for In-Hospital Mortality
}
\description{
Calculates the Get With The Guidelines-Heart Failure (GWTG-HF) risk score to predict in-hospital all-cause mortality in patients hospitalized with heart failure. The score uses admission vitals (SBP, HR), labs (BUN, Sodium), age, COPD history, and race.
}
\usage{
gwtg_hf_risk_score(age, systolic_bp, bun, heart_rate, sodium, copd,
                   race_black = 0, bun_units = "mg/dL", sodium_units = "mEq/L")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{systolic_bp}{
Numeric. Admission Systolic Blood Pressure (mmHg).
}
  \item{bun}{
Numeric. Admission Blood Urea Nitrogen level.
}
  \item{heart_rate}{
Numeric. Admission Heart Rate (bpm).
}
  \item{sodium}{
Numeric. Admission Serum Sodium level.
}
  \item{copd}{
Numeric (0 or 1). History of Chronic Obstructive Pulmonary Disease. (1 = Yes).
}
  \item{race_black}{
Numeric (0 or 1). Is the patient Black/African American? (1 = Yes, 0 = No). Note: Non-Black race adds points in this model.
}
  \item{bun_units}{
String. Units for BUN input. "mg/dL" (default) or "mmol/L".
}
  \item{sodium_units}{
String. Units for Sodium input. "mEq/L" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{GWTG_HF_Score}{The calculated risk score (Range 0-100+).}
\item{Est_In_Hospital_Mortality}{Estimated probability of in-hospital mortality.}
}
\references{
Peterson PN, Rumsfeld JS, Liang L, et al. A validated risk score for in-hospital mortality in patients with heart failure from the Get With the Guidelines Program. Circ Cardiovasc Qual Outcomes. 2010;3(1):25-32. doi:10.1161/CIRCOUTCOMES.109.854877
}
\examples{

# Example 1: High Risk
# 85yo, SBP 100, BUN 50, HR 100, Na 130, COPD, White
gwtg_hf_risk_score(85, 100, 50, 100, 130, 1, 0)

# Example 2: Low Risk
# 50yo, SBP 140, BUN 15, HR 70, Na 140, No COPD, Black
gwtg_hf_risk_score(50, 140, 15, 70, 140, 0, 1)
}
