\name{framingham_hf_criteria}
\alias{framingham_hf_criteria}
\title{
Framingham Heart Failure Diagnostic Criteria
}
\description{
Evaluates the Framingham criteria for the clinical diagnosis of congestive heart failure. Diagnosis requires the presence of at least 2 major criteria OR 1 major criterion plus 2 minor criteria. Note: Minor criteria are accepted only if they cannot be attributed to another medical condition.
}
\usage{
framingham_hf_criteria(pnd, orthopnea, elevated_jvp, rales, cardiomegaly,
                       pulmonary_edema, s3_gallop, hepatojugular_reflux,
                       weight_loss_response, ankle_edema, night_cough,
                       dyspnea_on_exertion, hepatomegaly, pleural_effusion,
                       tachycardia_gt_120, vital_capacity_decrease)
}
\arguments{
  \item{pnd}{
Numeric (0 or 1). Paroxysmal Nocturnal Dyspnea. (Major Criterion).
}
  \item{orthopnea}{
Numeric (0 or 1). Orthopnea. (Major Criterion).
}
  \item{elevated_jvp}{
Numeric (0 or 1). Elevated Jugular Venous Pressure. (Major Criterion).
}
  \item{rales}{
Numeric (0 or 1). Pulmonary rales. (Major Criterion).
}
  \item{cardiomegaly}{
Numeric (0 or 1). Cardiomegaly on chest X-ray. (Major Criterion).
}
  \item{pulmonary_edema}{
Numeric (0 or 1). Acute pulmonary edema on chest X-ray. (Major Criterion).
}
  \item{s3_gallop}{
Numeric (0 or 1). S3 gallop rhythm on auscultation. (Major Criterion).
}
  \item{hepatojugular_reflux}{
Numeric (0 or 1). Positive hepatojugular reflux. (Major Criterion).
}
  \item{weight_loss_response}{
Numeric (0 or 1). Weight loss > 4.5 kg in 5 days in response to treatment. (Major Criterion).
}
  \item{ankle_edema}{
Numeric (0 or 1). Bilateral ankle edema. (Minor Criterion).
}
  \item{night_cough}{
Numeric (0 or 1). Nocturnal cough. (Minor Criterion).
}
  \item{dyspnea_on_exertion}{
Numeric (0 or 1). Dyspnea on exertion. (Minor Criterion).
}
  \item{hepatomegaly}{
Numeric (0 or 1). Hepatomegaly. (Minor Criterion).
}
  \item{pleural_effusion}{
Numeric (0 or 1). Pleural effusion. (Minor Criterion).
}
  \item{tachycardia_gt_120}{
Numeric (0 or 1). Heart rate > 120 beats per minute. (Minor Criterion).
}
  \item{vital_capacity_decrease}{
Numeric (0 or 1). Vital capacity decreased by one-third from maximum recorded. (Minor Criterion).
}
}
\value{
A list containing:
\item{Result}{Text interpretation indicating whether criteria for Heart Failure are met.}
\item{Criteria_Counts}{The count of Major and Minor criteria identified.}
\item{Diagnosis_Met}{Boolean indicating if the diagnostic threshold was reached.}
}
\references{
McKee PA, Castelli WP, McNamara PM, Kannel WB. The natural history of congestive heart failure: the Framingham study. N Engl J Med. 1971;285(26):1441-1446. doi:10.1056/NEJM197112232852601
}
\examples{

# Example 1: Diagnosis Met (2 Major)
# PND (1), Rales (1)
framingham_hf_criteria(1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Diagnosis Met (1 Major + 2 Minor)
# Orthopnea (1), Ankle Edema (1), Dyspnea on Exertion (1)
framingham_hf_criteria(0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0)

# Example 3: Not Met (3 Minor only)
# Edema (1), Cough (1), DOE (1)
framingham_hf_criteria(0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0)
}
