\name{damico_prostate_risk}
\alias{damico_prostate_risk}
\title{
D'Amico Risk Classification for Prostate Cancer
}
\description{
Calculates the D'Amico Risk Classification for prostate cancer. This system stratifies patients into Low, Intermediate, or High risk of biochemical recurrence following localized treatment (surgery or radiation) based on PSA level, Gleason score, and Clinical T stage.
}
\usage{
damico_prostate_risk(psa, gleason_score, clinical_t_stage)
}
\arguments{
  \item{psa}{
Numeric. Prostate-Specific Antigen level in ng/mL.
}
  \item{gleason_score}{
Numeric. Total Gleason Score (sum of primary and secondary patterns).
}
  \item{clinical_t_stage}{
String. Clinical Tumor (T) Stage. Accepted values: "t1", "t1a", "t1b", "t1c", "t2a", "t2b", "t2c", "t3", "t3a", "t3b", "t4".
}
}
\value{
A list containing:
\item{Risk_Classification}{The determined risk group:
"Low Risk": PSA < 10 AND Gleason <= 6 AND T-stage T1-T2a.
"Intermediate Risk": PSA 10-20 OR Gleason 7 OR T-stage T2b.
"High Risk": PSA > 20 OR Gleason >= 8 OR T-stage >= T2c.}
}
\references{
D'Amico AV, Whittington R, Malkowicz SB, et al. Biochemical outcome after radical prostatectomy, external beam radiation therapy, or interstitial radiation therapy for clinically localized prostate cancer. JAMA. 1998;280(11):969-974. doi:10.1001/jama.280.11.969
}
\examples{

# Example 1: High Risk
# PSA 8 (Low), Gleason 8 (High), T2a (Low)
# Result = High Risk
damico_prostate_risk(8, 8, "t2a")

# Example 2: Low Risk
# PSA 5, Gleason 6, T1c
# Result = Low Risk
damico_prostate_risk(5, 6, "t1c")
}
