\name{covid_gram_score}
\alias{covid_gram_score}
\title{
COVID-GRAM Critical Illness Risk Score
}
\description{
Calculates the COVID-GRAM score to predict the risk of developing critical illness in patients hospitalized with COVID-19. Critical illness is defined as admission to the intensive care unit, invasive mechanical ventilation, or death. The model was developed by Liang et al. using data from 575 hospitals in China.
}
\usage{
covid_gram_score(age, x_ray_abnormality, hemoptysis, dyspnea, unconsciousness,
                 number_of_comorbidities, cancer_history, nlr, ldh,
                 direct_bilirubin, bilirubin_units = "umol/L")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{x_ray_abnormality}{
Numeric (0 or 1). Presence of radiographic abnormalities on Chest X-ray/CT. (1 = Yes).
}
  \item{hemoptysis}{
Numeric (0 or 1). Presence of hemoptysis. (1 = Yes).
}
  \item{dyspnea}{
Numeric (0 or 1). Presence of dyspnea. (1 = Yes).
}
  \item{unconsciousness}{
Numeric (0 or 1). Presence of unconsciousness or altered mental status. (1 = Yes).
}
  \item{number_of_comorbidities}{
Numeric. Count of comorbidities (e.g., COPD, hypertension, diabetes, coronary heart disease, CKD, etc.). (0, 1, or >=2).
}
  \item{cancer_history}{
Numeric (0 or 1). History of cancer. (1 = Yes).
}
  \item{nlr}{
Numeric. Neutrophil-to-lymphocyte ratio.
}
  \item{ldh}{
Numeric. Lactate dehydrogenase level (U/L).
}
  \item{direct_bilirubin}{
Numeric. Direct bilirubin level.
}
  \item{bilirubin_units}{
String. Units for direct bilirubin. "umol/L" (default) or "mg/dL".
}
}
\value{
A list containing:
\item{Critical_Illness_Probability}{The estimated percentage probability of critical illness.}
\item{Risk_Category}{Risk stratification (Low < 1.7\%, Medium 1.7-40.4\%, High > 40.4\%).}
}
\references{
Liang W, Liang H, Ou L, et al. Development and Validation of a Clinical Risk Score to Predict the Occurrence of Critical Illness in Hospitalized Patients With COVID-19. JAMA Intern Med. 2020;180(8):1081-1089. doi:10.1001/jamainternmed.2020.2033
}
\examples{

# Example 1: High Risk
# 70yo, Abnormal CXR, Dyspnea, 2 Comorbs, Cancer, NLR 10, LDH 400, D-Bili 6 umol/L
covid_gram_score(70, 1, 0, 1, 0, 2, 1, 10, 400, 6, "umol/L")

# Example 2: Low Risk
# 30yo, Normal CXR, No symptoms, 0 Comorbs, Normal Labs
covid_gram_score(30, 0, 0, 0, 0, 0, 0, 2, 150, 3, "umol/L")
}
