\name{ariscat_score}
\alias{ariscat_score}
\title{
ARISCAT Score for Postoperative Pulmonary Complications
}
\description{
Calculates the ARISCAT (Assess Respiratory Risk in Surgical Patients in Catalonia) score to predict the risk of developing postoperative pulmonary complications (PPC) such as respiratory failure, infection, pleural effusion, atelectasis, pneumothorax, bronchospasm, or aspiration pneumonitis.
}
\usage{
ariscat_score(age, spo2, resp_infection_last_month, anemia_hb_le_10,
              incision_site, duration_surgery_hours, emergency_surgery)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{spo2}{
Numeric. Preoperative oxygen saturation (\%) on room air.
}
  \item{resp_infection_last_month}{
Numeric (0 or 1). Respiratory infection within the last month. (1 = Yes).
}
  \item{anemia_hb_le_10}{
Numeric (0 or 1). Preoperative anemia with Hemoglobin <= 10 g/dL. (1 = Yes).
}
  \item{incision_site}{
String. Location of surgical incision. Options: "peripheral" (0 pts), "upper_abdominal" (15 pts), "intrathoracic" (24 pts).
}
  \item{duration_surgery_hours}{
Numeric. Expected or actual duration of surgery in hours.
}
  \item{emergency_surgery}{
Numeric (0 or 1). Is the procedure an emergency? (1 = Yes).
}
}
\value{
A list containing:
\item{ARISCAT_Score}{The calculated score (Range 0-123).}
\item{Risk_Group}{Risk classification (Low < 26, Intermediate 26-44, High >= 45).}
\item{Est_Pulmonary_Complication_Rate}{Estimated percentage risk of PPCs.}
}
\references{
Canet J, Gallart L, Gomar C, et al. Prediction of postoperative pulmonary complications in a population-based surgical cohort. Anesthesiology. 2010;113(6):1338-1350. doi:10.1097/ALN.0b013e3181fc6e0a
}
\examples{

# Example 1: High Risk
# 82yo, SpO2 90\%, Intrathoracic, >3h surgery
# Score = 16 + 24 + 0 + 0 + 24 + 23 + 0 = 87
ariscat_score(82, 90, 0, 0, "intrathoracic", 3.5, 0)

# Example 2: Low Risk
# 45yo, SpO2 98\%, Peripheral, 1h surgery
# Score = 0
ariscat_score(45, 98, 0, 0, "peripheral", 1, 0)
}
