\name{abbreviated_mental_test_10}
\alias{abbreviated_mental_test_10}
\title{
Abbreviated Mental Test (AMT-10)
}
\description{
Calculates the AMT-10 score, a screening tool for cognitive impairment in elderly patients. It consists of 10 questions, each scoring 1 point for a correct answer. A score of less than 8 suggests possible cognitive impairment.
}
\usage{
abbreviated_mental_test_10(age_correct, time_correct, address_recall_correct,
                           year_correct, place_correct, recognition_correct,
                           dob_correct, ww1_date_correct, monarch_correct,
                           count_backwards_correct)
}
\arguments{
  \item{age_correct}{
Numeric (0 or 1). Correctly states own age.
}
  \item{time_correct}{
Numeric (0 or 1). Correctly states time (to nearest hour).
}
  \item{address_recall_correct}{
Numeric (0 or 1). Correctly recalls an address (e.g., "42 West Street") given by the examiner at the beginning of the test.
}
  \item{year_correct}{
Numeric (0 or 1). Correctly states the current year.
}
  \item{place_correct}{
Numeric (0 or 1). Correctly states the name of the place (e.g., hospital name or address).
}
  \item{recognition_correct}{
Numeric (0 or 1). Correctly identifies two persons (e.g., doctor, nurse).
}
  \item{dob_correct}{
Numeric (0 or 1). Correctly states date of birth.
}
  \item{ww1_date_correct}{
Numeric (0 or 1). Correctly states the year World War I began.
}
  \item{monarch_correct}{
Numeric (0 or 1). Correctly states the name of the current Monarch (or President/Head of State depending on region).
}
  \item{count_backwards_correct}{
Numeric (0 or 1). Correctly counts backwards from 20 to 1.
}
}
\value{
A list containing:
\item{Total_Score}{Sum of the correct answers (Range 0-10).}
\item{Interpretation}{Clinical suggestion based on the score (Normal >= 8, Abnormal < 8).}
}
\references{
Hodkinson HM. Evaluation of a mental test score for assessment of mental impairment in the elderly. Age Ageing. 1972;1(4):233-238. doi:10.1093/ageing/1.4.233
}
\examples{

# Example 1: Normal Cognition
# All correct
abbreviated_mental_test_10(1, 1, 1, 1, 1, 1, 1, 1, 1, 1)

# Example 2: Possible Impairment
# Missed address recall, year, and counting backwards
abbreviated_mental_test_10(1, 1, 0, 0, 1, 1, 1, 1, 1, 0)
}
