% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{make_grouped_pagenums}
\alias{make_grouped_pagenums}
\title{Assign Page Numbers to Presorted Grouped Data}
\usage{
make_grouped_pagenums(var, rows)
}
\arguments{
\item{var}{A vector of group labels, presorted so that identical
values are contiguous.}

\item{rows}{Integer. The maximum number of rows per page.}
}
\value{
An integer vector of the same length as `var``, indicating
the assigned page number for each element.
}
\description{
Assigns sequential page numbers to elements of a vector, grouping by
unique values and allocating a specified number of rows per page.
The input vector must be presorted by group.
}
\details{
The function splits the input vector into groups, then assigns page numbers
within each group so that each page contains up to `rows`` items.
Page numbers increment sequentially across groups. If the input is not
presorted by group, the function will throw an error.
}
\examples{
library(dplyr)
iris |>
  mutate(
    page = make_grouped_pagenums(Species, 5)
  )

}
