% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{clinify_titles_default}
\alias{clinify_titles_default}
\alias{clinify_footnotes_default}
\alias{clinify_table_default}
\alias{clinify_caption_default}
\alias{clinify_grouplabel_default}
\alias{clinify_docx_default}
\title{Apply Default Clinical Styling to Clintables}
\usage{
clinify_titles_default(x, ...)

clinify_footnotes_default(x, ...)

clinify_table_default(x, ...)

clinify_caption_default(x, ...)

clinify_grouplabel_default(x, ...)

clinify_docx_default()
}
\arguments{
\item{x}{A \code{clintable} object representing the table (title or footnote).}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{clintable} object with the applied styling.
}
\description{
These functions apply default styling to \code{clintable} objects used for
clinical tables, including titles and footnotes. The styling includes
removing borders, setting font properties, and adjusting table width,
line spacing, and padding.
}
\examples{

op <- options()

sect <- clinify_docx_default()

# Save out options to grab defaults
options(
  clinify_docx_default = sect,
  clinify_titles_default = clinify_titles_default,
  clinify_footnotes_default = clinify_footnotes_default,
  clinify_table_default = clinify_table_default,
  clinify_caption_default = clinify_caption_default,
  clinify_grouplabel_default = clinify_grouplabel_default
)

options(op)
}
\concept{Clinify Defaults}
