% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_dataset.R
\name{clean_dataset}
\alias{clean_dataset}
\title{Clean Dataset}
\usage{
clean_dataset(
  df,
  variables = NULL,
  remove_duplicates = TRUE,
  convert_to_case = NULL
)
}
\arguments{
\item{df}{A data frame to be cleaned.}

\item{variables}{Optional; a vector of variable names to specifically clean.
If NULL, applies cleaning to all variables.}

\item{remove_duplicates}{Logical; whether to remove duplicate rows.}

\item{convert_to_case}{Optional; convert character variables to "lower" or "upper" case.}
}
\value{
A cleaned data frame.
}
\description{
Removes duplicate rows, standardizes column names and text values to uppercase
or lowercase, and performs basic data cleaning on a data frame.
}
\examples{
\donttest{
  df <- data.frame(name = c("Alice", "Bob", "Alice"),
                   score = c(90, 85, 90),
                   stringsAsFactors = FALSE)
  clean_dataset(df, remove_duplicates = TRUE, convert_to_case = "upper")
}
}
