% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_validate.R
\name{build_metadata_comparison}
\alias{build_metadata_comparison}
\title{Build Metadata Comparison}
\usage{
build_metadata_comparison(df1, df2)
}
\arguments{
\item{df1}{First data frame (base).}

\item{df2}{Second data frame (compare).}
}
\value{
A list with:
\item{type_mismatches}{Data frame of variables with differing R classes}
\item{label_mismatches}{Data frame of variables with differing labels}
\item{length_mismatches}{Data frame of variables with differing lengths
(max character width or haven width attribute)}
\item{format_mismatches}{Data frame of variables with differing SAS format
attributes (format.sas or display_format)}
\item{order_match}{Logical: TRUE if common column ordering matches}
\item{order_df1}{Character: column order in df1 for common columns}
\item{order_df2}{Character: column order in df2 for common columns}
}
\description{
Internal function to compare metadata attributes (types, labels, lengths,
formats, and column order) between two datasets.
}
\keyword{internal}
