% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.result.R
\name{ciu.result.new}
\alias{ciu.result.new}
\title{CIU result object}
\usage{
ciu.result.new(ci, cu, cmin, cmax, outval)
}
\arguments{
\item{ci}{vector of CI values, one per output}

\item{cu}{vector of CU values, one per output}

\item{cmin}{vector of cmin values, one per output}

\item{cmax}{vector of cmax values, one per output}

\item{outval}{vector of black-box output values, one per output}
}
\value{
An object of class \code{ciu.result}, which is a \link{data.frame} with
(at least) five columns:
\itemize{
\item \verb{CI values}: one row per output of the black-box model
\item \verb{CU values}: one row per output of the black-box model
\item \verb{cmin values}: one row per output of the black-box model
\item \verb{cmax values}: one row per output of the black-box model
\item \verb{outval values}: one row per output of the black-box model
}
}
\description{
Create object of class \code{ciu.result}, which stores results of CIU
calculations. The \code{ciu$explain} and \link{ciu.explain} methods return a \code{ciu.result} object.
}
\author{
Kary Främling
}
