% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccRaster}
\alias{ccRaster}
\title{Add raster image}
\usage{
ccRaster(
  image,
  x,
  y,
  width,
  height,
  facing = c("inside", "outside", "reverse.clockwise", "clockwise", "downward",
    "bending.inside", "bending.outside"),
  niceFacing = FALSE,
  scaling = 1
)
}
\arguments{
\item{image}{A \code{raster} object, or an object that can be converted by \code{\link[grDevices]{as.raster}}.}

\item{x}{Position of the center of the raster image, measued in the data coordinate in the cell.}

\item{y}{Position of the center of the raster image, measued in the data coordinate in the cell.}

\item{width}{Width of the raster image. When \code{facing} is one of "inside", "outside", "clockwise" and "reverse.clockwise", the image should have absolute size where the value of \code{width} should be specified like \code{20mm}, \code{1cm} or \code{0.5inche}. When \code{facing} is one of \code{bending.inside} and \code{bending.outside}, the value of \code{width} is measured in the data coordinate in the cell.}

\item{height}{Height of the raster image. Same format as \code{width}. If the value of \code{height} is omit,  default height is calculated by taking the aspect ratio of the original image. But when \code{facing} is one of \code{bending.inside} and \code{bending.outside}, \code{height} is mandatory to set.}

\item{facing}{Facing of the raster image.}

\item{niceFacing}{Facing of text. Please refer to vignette for different settings.}

\item{scaling}{Scaling factor to resize the raster image.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.raster]{circlize::circos.raster} while drawing.
}
\examples{
\donttest{
library(circlizePlus)
library(png)
image <- system.file("extdata", "Rlogo.png", package = "circlize")
image <- as.raster(readPNG(image))
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:4], xlim = c(0, 10))
track <- ccTrack(ylim = c(0, 1))
cell <- ccCell(sector.index = "a") + ccRaster(image = image, x = 5, y = 0.5,
width = "2cm", height = "2cm", facing = "inside", niceFacing = TRUE)
track <- track + cell
cc + track
}
}
