% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie-sql.R
\name{cie10_sql}
\alias{cie10_sql}
\title{Ejecutar consultas SQL sobre CIE-10 Chile}
\usage{
cie10_sql(query, close = TRUE)
}
\arguments{
\item{query}{String SQL valido SQLite (SELECT/WHERE/JOIN)}

\item{close}{Logical, cerrar conexion post-query (default TRUE)}
}
\value{
tibble resultado query
}
\description{
Ejecutar consultas SQL sobre CIE-10 Chile
}
\examples{
\donttest{
# Buscar diabetes
cie10_sql("SELECT codigo, descripcion FROM cie10 WHERE codigo LIKE 'E11\%'")

# Contar por capitulo
cie10_sql("SELECT capitulo, COUNT(*) n FROM cie10 GROUP BY capitulo")
}

# Join con datos pacientes (externo)
\dontrun{
cie10_sql("SELECT p.id, c.descripcion
           FROM pacientes p JOIN cie10 c ON p.codigo = c.codigo")
}
}
