% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chemstation_ms.R
\name{read_chemstation_ms}
\alias{read_chemstation_ms}
\title{Read 'Agilent ChemStation' MS file.}
\usage{
read_chemstation_ms(
  path,
  what = c("MS1", "BPC", "TIC"),
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  collapse = TRUE
)
}
\arguments{
\item{path}{Path to 'Agilent' \code{.ms} file.}

\item{what}{What stream to get: current options are \code{MS1}, \code{BPC}
and/or \code{TIC}. If a stream is not specified, the function will return all
streams.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Logical. Whether to attach metadata. Defaults to \code{TRUE}.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{collapse}{Logical. Whether to collapse lists that only contain a single
element. Defaults to \code{TRUE}.}
}
\value{
A 2D chromatogram in the format specified by \code{data_format} and
\code{format_out}. If \code{data_format} is \code{wide}, the chromatogram will
be returned with retention times as rows and a single column for the intensity.
If \code{long} format is requested, two columns will be returned: one for the
retention time and one for the intensity. The \code{format_out} argument
determines whether the chromatogram is returned as a \code{matrix},
\code{data.frame}, or \code{data.table}. Metadata can be attached to the
chromatogram as \code{\link{attributes}} if \code{read_metadata} is \code{TRUE}.
}
\description{
Reads 'Agilent ChemStation MSD Spectral Files' beginning with
\code{x01/x32/x00/x00}.
}
\note{
Many thanks to Evan Shi and Eugene Kwan for providing helpful
information on the structure of these files in the
\href{https://rainbow-api.readthedocs.io/en/latest/agilent/ms.html}{rainbow documentation}.
}
\examples{
\dontrun{
read_chemstation_ms(path)
}
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_d}()},
\code{\link{read_agilent_dx}()},
\code{\link{read_chemstation_ch}()},
\code{\link{read_chemstation_csv}()},
\code{\link{read_chemstation_reports}()},
\code{\link{read_chemstation_uv}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
