% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans_gcms.R
\name{kmeans_gcms}
\alias{kmeans_gcms}
\title{Perform K-Means Clustering on GCMs}
\usage{
kmeans_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  k = 3,
  method = NULL
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector of names of the variables to include, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted.
Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Should the data be centered and scaled? Default is \code{TRUE}.}

\item{k}{Integer. The number of clusters to create.}

\item{method}{Character. The method for distance matrix computation. Default is "euclidean." Possible values are:
"euclidean," "maximum," "manhattan," "canberra," "binary," or "minkowski." If \code{NULL}, clustering will be performed on the raw variable data.}
}
\value{
A scatter plot showing the resulting clusters and the suggested GCMs.
}
\description{
This function performs k-means clustering on a distance matrix and produces a scatter plot of the resulting clusters.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
kmeans_gcms(s, var_names, study_area, k = 3)

}
\seealso{
\code{\link{transform_gcms}} \code{\link{flatten_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
