% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_gcms.R
\name{import_gcms}
\alias{import_gcms}
\title{Import GCM Data to R}
\usage{
import_gcms(
  path = "input_data/WorldClim_data_gcms",
  extension = ".tif",
  recursive = TRUE,
  gcm_names = NULL,
  var_names = NULL
)
}
\arguments{
\item{path}{Character. A string specifying the path to the GCM files.}

\item{extension}{Character. The file extension of the stack files. Default is \code{".tif"}, the standard extension for WorldClim 2.1 data.}

\item{recursive}{Logical. Should the function import stacks recursively (i.e., search for files within subfolders)? Default is \code{TRUE}.}

\item{gcm_names}{Character. A vector of names to assign to each GCM.}

\item{var_names}{Character. A vector of names to assign to each variable.}
}
\value{
A list of stacks, where each element corresponds to a GCM from the specified path.
}
\description{
This function imports GCM stack files from a folder into R.
}
\examples{
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = c("bio1", "bio12"))

}
\seealso{
\code{\link{WorldClim_data}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
