% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenologyFitter.R
\name{PhenoFlex_fixedDynModelGAUSSwrapper}
\alias{PhenoFlex_fixedDynModelGAUSSwrapper}
\title{PhenoFlex_fixedDynModelGAUSSwrapper}
\usage{
PhenoFlex_fixedDynModelGAUSSwrapper(
  x,
  par,
  A0 = 139500,
  A1 = 2.567e+18,
  E0 = 4153.5,
  E1 = 12888.8,
  slope = 1.6,
  Tf = 4
)
}
\arguments{
\item{x}{data.frame with at least columns `Temp` and `JDay`}

\item{par}{numeric vector of length 11 with the `PhenoFlex` fit
parameters in the following order: 1. yc, 2. zc, 3. s1, 4. Tu, 5. E0,
6. E1, 7, A0, 8. A1, 9. Tf, 10. Tc, 11. Tb and 12. slope. For details see
\link{PhenoFlex}}

\item{A0}{numeric. Parameter \eqn{A_0}{A0} of the dynamic model}

\item{A1}{numeric. Parameter \eqn{A_1}{A1} of the dynamic model}

\item{E0}{numeric. Parameter \eqn{E_0}{E0} of the dynamic model}

\item{E1}{numeric. Parameter \eqn{E_1}{E1} of the dynamic model}

\item{slope}{numeric. Slope parameter for sigmoidal function}

\item{Tf}{numeric. Transition temperature (in degree Kelvin) for the
sigmoidal function}
}
\value{
A single numeric value with the JDay prediction for the
temperaturs in `x$Temp` and the \link{PhenoFlex} parameters
in `par`.
}
\description{
PhenoFlex wrapper function for the `phenologyFitter` function using
the GAUSS heat accumulation model and parameters of the dynamical model
fixed.
}
