% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childeswordfreq-package.R
\docType{package}
\name{childeswordfreq-package}
\alias{childeswordfreq}
\alias{childeswordfreq-package}
\title{childeswordfreq: Word and Phrase Frequency Tools for CHILDES}
\description{
The \code{childeswordfreq} package provides a simple, reproducible workflow for
extracting word and phrase frequencies from the CHILDES database using the
\code{childesr} API.
}
\details{
The main user-facing functions are:
\itemize{
\item \code{\link[=word_counts]{word_counts()}} for word and stem frequencies by speaker role, with
optional normalization and Zipf scaling, exported to Excel workbooks.
\item \code{\link[=phrase_counts]{phrase_counts()}} for counts of multi-word expressions in utterance text,
with simple wildcard support and optional normalization.
}

Optional on-disk caching can be enabled via \code{\link[=cwf_cache_enable]{cwf_cache_enable()}} to speed up
repeated queries, and disabled with \code{\link[=cwf_cache_disable]{cwf_cache_disable()}}. The current cache
status can be checked with \code{\link[=cwf_cache_enabled]{cwf_cache_enabled()}}.

All queries are performed live against CHILDES through \code{childesr}; no local
copy of the corpora is required.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/n-albudoor/childeswordfreq}
  \item Report bugs at \url{https://github.com/n-albudoor/childeswordfreq/issues}
}

}
\author{
\strong{Maintainer}: Nahar Albudoor \email{n.albudoor@gmail.com}

}
\keyword{internal}
