% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R, R/task.R
\name{lib}
\alias{lib}
\alias{lib.NULL}
\alias{lib.character}
\alias{lib.lib_path_isolated}
\alias{lib.lib_path_default}
\alias{lib.task}
\alias{lib.install_task}
\alias{lib.check_task}
\title{Get Library Location}
\usage{
lib(x, ...)

\method{lib}{`NULL`}(x, ...)

\method{lib}{character}(x, ...)

\method{lib}{lib_path_isolated}(
  x,
  ...,
  lib.root = tempdir(),
  dir_hash = hash(Sys.time(), n = 8),
  name = ""
)

\method{lib}{lib_path_default}(x, ..., lib.loc = .libPaths())

\method{lib}{task}(x, ...)

\method{lib}{install_task}(x, ...)

\method{lib}{check_task}(x, ...)
}
\arguments{
\item{x}{An object describing a library location}

\item{...}{additional parameters passed to methods}

\item{lib.root}{A root directory for the isolated library.}

\item{dir_hash}{unique identifier of the isolated library}

\item{name}{human-readable subname of the isolated library}

\item{lib.loc}{Library paths, defaulting to \code{\link[=.libPaths]{.libPaths()}}.}
}
\description{
Get Library Location
}
\keyword{internal}
