% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R, R/methods.R
\name{cff_class}
\alias{cff_class}
\alias{cff_ref}
\alias{cff_ref_lst}
\alias{cff_pers}
\alias{cff_pers_lst}
\alias{print.cff}
\alias{c.cff}
\alias{[.cff_ref_lst}
\alias{[.cff_pers_lst}
\alias{as.data.frame.cff}
\alias{as.data.frame.cff_pers_lst}
\alias{as.data.frame.cff_pers}
\alias{as.data.frame.cff_ref_lst}
\alias{as.data.frame.cff_ref}
\alias{head.cff}
\alias{tail.cff}
\alias{as.list.cff}
\alias{toBibtex.cff}
\alias{toBibtex.cff_ref_lst}
\alias{toBibtex.cff_ref}
\alias{toBibtex.cff_pers_lst}
\alias{toBibtex.cff_pers}
\alias{as.person.cff_pers}
\alias{as.person.cff_pers_lst}
\alias{as.person.cff}
\alias{as.person.cff_ref}
\alias{as.person.cff_ref_lst}
\title{The \code{cff} class}
\description{
\subsection{The \code{cff} class}{

\href{https://cran.r-project.org/package=cffr}{\strong{cffr}} implements a S3 object with
\code{\link{class}} \code{cff}, that it is used to represent the information of a
\code{CITATION.cff} file in \strong{R}.

Under the hood, a \code{cff} object is simply a named \code{\link{list}} to which we added
additional methods, most notably \code{\link{print}} and \code{\link[=as_cff]{as_cff()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{a_named_list <- list(
  first = "I", second = "am", third = "a", fourth = "list",
  fifth = "with", sixth = "names", "none" = NULL
)

# As cff
a_cff_object <- as_cff(a_named_list)

class(a_cff_object)
#> [1] "cff"

a_cff_object
#> first: I
#> second: am
#> third: a
#> fourth: list
#> fifth: with
#> sixth: names

is.list(a_cff_object)
#> [1] TRUE
}\if{html}{\out{</div>}}

\code{\link[=as_cff]{as_cff()}} not only converts a \code{list} to \code{cff} but also removes items (known as
\code{keys} in CFF terminology) that are \code{NULL} or \code{NA}.
\subsection{Sub-classes}{

\strong{cffr} implements two special sub-classes of \code{cff}, with the aim of
representing two special types of objects defined in the \href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{CFF Schema}:
\itemize{
\item \code{definition.person} and \code{definition.entity}: CFF definition for sub-lists
representing persons or entities. In \strong{cffr} the sub-class \code{cff_pers_lst}
has been implemented to collect an array of \code{definition.person/entity},
where each individual person or entity of the array has a sub-class
\code{cff_pers}.
\item Similarly, \code{definition.reference} is the definition of CFF for collecting
references to related works and other articles of software used in the
development of the main work of the CFF file. This is implemented in
\strong{cffr} as a sub-class named \code{cff_ref_lst} for arrays of
\code{definition.reference} where each element of the array has a sub-class named
\code{cff_ref}.
}

These two sub-classes does not provide full valid \code{cff} objects, but adapts
information to the schema required by CFF:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Using the utils::person() function

## Array
two_persons <- as_cff_person(
  c(
    person("A", "person", comment = c(ORCID = "0000-0001-8457-4658")),
    person("An entity", email = "fake@gmail.com")
  )
)

two_persons
#> - family-names: person
#>   given-names: A
#>   orcid: https://orcid.org/0000-0001-8457-4658
#> - name: An entity
#>   email: fake@gmail.com

class(two_persons)
#> [1] "cff_pers_lst" "cff"

# Single element

two_persons[[1]]
#> family-names: person
#> given-names: A
#> orcid: https://orcid.org/0000-0001-8457-4658

class(two_persons[[1]])
#> [1] "cff_pers" "cff"

# Array of references

cit <- c(citation(), citation("yaml"))

ref_list <- as_cff(cit)

ref_list
#> - type: manual
#>   title: 'R: A Language and Environment for Statistical Computing'
#>   authors:
#>   - name: R Core Team
#>   institution:
#>     name: R Foundation for Statistical Computing
#>     address: Vienna, Austria
#>   year: '2025'
#>   url: https://www.R-project.org/
#> - type: manual
#>   title: 'yaml: Methods to Convert R Data to YAML and Back'
#>   authors:
#>   - family-names: Stephens
#>     given-names: Jeremy
#>   - family-names: Simonov
#>     given-names: Kirill
#>   year: '2025'
#>   notes: R package version 2.3.12
#>   url: https://CRAN.R-project.org/package=yaml
#>   doi: 10.32614/CRAN.package.yaml

class(ref_list)
#> [1] "cff_ref_lst" "cff"

# Single element

ref_list[[1]]
#> type: manual
#> title: 'R: A Language and Environment for Statistical Computing'
#> authors:
#> - name: R Core Team
#> institution:
#>   name: R Foundation for Statistical Computing
#>   address: Vienna, Austria
#> year: '2025'
#> url: https://www.R-project.org/

class(ref_list[[1]])
#> [1] "cff_ref" "cff"
}\if{html}{\out{</div>}}
}

}

\subsection{Valid \code{cff} objects}{

Creating a \code{cff} object does not ensure its validity according to the \href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{CFF Schema}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{class(a_cff_object)
#> [1] "cff"

cff_validate(a_cff_object)
#> == Validating cff ==============================================================
#> x Oops! This <cff> has the following errors:
#> * cff.authors: is required
#> * cff["cff-version"]: is required
#> * cff.message: is required
#> * cff.title: is required
}\if{html}{\out{</div>}}

\code{\link[=cff_validate]{cff_validate()}} gives minimal messages of what's wrong with our \code{cff} and
(invisibly) returns the result of the validation (\code{TRUE/FALSE}).

We can use \code{\link[=cff_modify]{cff_modify()}} to add more keys:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cff_valid <- cff_modify(a_cff_object,
  authors = as_cff_person("\{James and James\}"),
  cff_version = "1.2.0",
  message = "Hi there",
  title = "My title"
)


# Remove invalid keys
cff_valid <- as_cff(cff_valid[names(cff_valid) \%in\% cff_schema_keys()])

cff_valid
#> authors:
#> - name: James and James
#> cff-version: 1.2.0
#> message: Hi there
#> title: My title

cff_validate(cff_valid)
#> == Validating cff ==============================================================
#> v Congratulations! This <cff> is valid
}\if{html}{\out{</div>}}
}

\subsection{Base methods provided by \strong{cffr}}{

\strong{cffr} version 1.0.0 provides additional S3 Methods for common coercing
functions of the \strong{base} and \strong{utils} package.
\subsection{\code{\link[=as.data.frame]{as.data.frame()}}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{minimal_cff <- cff()

minimal_cff
#> cff-version: 1.2.0
#> message: If you use this software, please cite it using these metadata.
#> title: My Research Software
#> authors:
#> - family-names: Doe
#>   given-names: John

as_df <- as.data.frame(minimal_cff)

class(as_df)
#> [1] "data.frame"

t(as_df)
#>                         [,1]                                                            
#> cff_version             "1.2.0"                                                         
#> message                 "If you use this software, please cite it using these metadata."
#> title                   "My Research Software"                                          
#> authors.00.family_names "Doe"                                                           
#> authors.00.given_names  "John"
}\if{html}{\out{</div>}}
}

\subsection{\code{\link[=c]{c()}}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{new_keys <- c("date-released" = "2020-01-31", abstract = "Minimal example")

c(minimal_cff, new_keys)
#> cff-version: 1.2.0
#> message: If you use this software, please cite it using these metadata.
#> title: My Research Software
#> authors:
#> - family-names: Doe
#>   given-names: John
#> date-released: '2020-01-31'
#> abstract: Minimal example
}\if{html}{\out{</div>}}
}

\subsection{\code{\link[=as.list]{as.list()}}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{as.list(minimal_cff)
#> $`cff-version`
#> [1] "1.2.0"
#> 
#> $message
#> [1] "If you use this software, please cite it using these metadata."
#> 
#> $title
#> [1] "My Research Software"
#> 
#> $authors
#> $authors[[1]]
#> $authors[[1]]$`family-names`
#> [1] "Doe"
#> 
#> $authors[[1]]$`given-names`
#> [1] "John"
}\if{html}{\out{</div>}}
}

\subsection{\code{\link[=as.person]{as.person()}}}{

Only for \code{cff_pers_lst} and \code{cff_pers} objects:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{as.person(two_persons)
#> [1] "A person (ORCID: <https://orcid.org/0000-0001-8457-4658>)"
#> [2] "An entity <fake@gmail.com>"
}\if{html}{\out{</div>}}
}

\subsection{\code{\link[=toBibtex]{toBibtex()}}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# For cff
toBibtex(minimal_cff)
#> @Misc\{doe,
#>   title = \{My Research Software\},
#>   author = \{John Doe\},
#> \}

# cff_ref, cff_ref_lst
toBibtex(cit)
#> @Manual\{,
#>   title = \{R: A Language and Environment for Statistical Computing\},
#>   author = \{\{R Core Team\}\},
#>   organization = \{R Foundation for Statistical Computing\},
#>   address = \{Vienna, Austria\},
#>   year = \{2025\},
#>   url = \{https://www.R-project.org/\},
#> \}
#> 
#> @Manual\{,
#>   title = \{yaml: Methods to Convert R Data to YAML and Back\},
#>   author = \{Jeremy Stephens and Kirill Simonov\},
#>   year = \{2025\},
#>   note = \{R package version 2.3.12\},
#>   url = \{https://CRAN.R-project.org/package=yaml\},
#>   doi = \{10.32614/CRAN.package.yaml\},
#> \}

# cff_pers, cff_pers_lst
toBibtex(two_persons)
#> person, A and \{An entity\}
}\if{html}{\out{</div>}}
}

}
}
\references{
\itemize{
\item Wickham H (2019). "S3." In \emph{Advanced R}, 2nd edition.
Chapman and Hall/CRC. \doi{10.1201/9781351201315},
\url{https://adv-r.hadley.nz/s3.html}.
}
}
\seealso{
Coercing between \strong{R} classes with \strong{S3 Methods}:
\code{\link{as_bibentry}()},
\code{\link{as_cff}()},
\code{\link{as_cff_person}()}
}
\concept{s3method}
\keyword{internal}
