% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_players.R
\name{cfbd_player_info}
\alias{cfbd_player_info}
\title{\strong{Player information lookup}}
\usage{
cfbd_player_info(search_term, position = NULL, team = NULL, year = NULL)
}
\arguments{
\item{search_term}{(\emph{String} required): Search term for the player you are trying to look up}

\item{position}{(\emph{string} optional): Position of the player you are searching for.
Position Group  - options include:
\itemize{
\item Offense: QB, RB, FB, TE,  OL, G, OT, C, WR
\item Defense: DB, CB, S, LB,  DE, DT, NT, DL
\item Special Teams: K, P, LS, PK
}}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}

\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}).
If left NULL, API default will only provide results for most recent year of final rosters: 2020}
}
\value{
\code{\link[=cfbd_player_info]{cfbd_player_info()}} - A data frame with 12 variables:
\describe{
\item{\code{athlete_id}:character.}{Unique player identifier \code{athlete_id}.}
\item{\code{team}:character.}{Team of the player.}
\item{\code{name}:character.}{Player name.}
\item{\code{first_name}:character.}{Player first name.}
\item{\code{last_name}:character.}{Player last name.}
\item{\code{weight}:integer.}{Player weight.}
\item{\code{height}:integer.}{Player height.}
\item{\code{jersey}:integer.}{Player jersey number.}
\item{\code{position}:character.}{Player position.}
\item{\code{home_town}:character.}{Player home town.}
\item{\code{team_color}:character.}{Player team color.}
\item{\code{team_color_secondary}:character.}{Player team secondary color.}
}
}
\description{
\strong{Player information lookup}
}
\examples{
\donttest{
  try(cfbd_player_info(search_term = "James", position = "DB", team = "Florida State", year = 2017))

  try(cfbd_player_info(search_term = "Lawrence", team = "Clemson"))
}
}
\seealso{
Other CFBD Players: 
\code{\link{cfbd_player_returning}()},
\code{\link{cfbd_player_usage}()}
}
\concept{CFBD Players}
\keyword{Players}
