% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censoredElasticity.R
\name{censoredElasticity}
\alias{censoredElasticity}
\title{Numerical approximation to censored AI or QUAI demand system elasticities, including demographic variable.}
\usage{
censoredElasticity(
  Prices = matrix(),
  Budget = matrix(),
  ShareNames = NULL,
  Demographics = matrix(),
  DemographicNames = NULL,
  Params = matrix(),
  quaids = FALSE,
  vcov = matrix(),
  func,
  ...
)
}
\arguments{
\item{Prices}{A matrix of logged prices with (nxm) dimensions where n is the number of observations and m the number of shares.}

\item{Budget}{A matrix of logged total expenditure/budget with (nx1) dimensions where n is the number of observations.}

\item{ShareNames}{A vector of strings containing the share names with (mx1) dimensions where m is the number of shares.}

\item{Demographics}{A matrix of demographic variables with (nxt) dimensions where n is the number of observations and t the number of demographic variables.}

\item{DemographicNames}{A vector of strings containing the demographic names with (tx1) dimensions where t is the number of demographic variables.}

\item{Params}{A vector containing the parameters alpha, beta, gamma, and theta and lambda if elected.}

\item{quaids}{Logical. Should quadratic form be used instead?}

\item{vcov}{A variance-covariance matrix of the parameters. Must be positive semi-definite and symmetric.}

\item{func}{A function to be applied to the data at which point estimate elasticities are being evaluated.}

\item{...}{Additional arguments to be passed to func.}
}
\value{
A list containing a matrix of price and income elasticities, a matrix with their respective standard errors approximated using the delta method, and a matrix of expected shares that can serve to run further post-estimation analyses.
}
\description{
Numerical approximation to censored AI or QUAI demand system elasticities, including demographic variable.
}
\examples{

\dontrun{

testing_data <- censoredAIDS::MexicanHH_foodConsumption

# Organizing the data for comfort
s1 <- testing_data$s1
s2 <- testing_data$s2
s3 <- testing_data$s3
s4 <- testing_data$s4
s5 <- testing_data$s5
s6 <- testing_data$s6

lnp1 <- testing_data$lnp1
lnp2 <- testing_data$lnp2
lnp3 <- testing_data$lnp3
lnp4 <- testing_data$lnp4
lnp5 <- testing_data$lnp5
lnp6 <- testing_data$lnp6

age <- testing_data$age
size <- testing_data$size
sex <- testing_data$sex
educ <- testing_data$educ

# Alpha
b0 <- rep(0, 5)

# Beta
b0 <- c(b0, rep(0.003, 5))

# Gamma
b0 <- c(b0,0.01,0,0.01,0,0, 0.01,0,0,0,0.01,0,0,0,0,0.01)

# Demos
b0 <- c(b0,rep(0.002, 20))

# Sigma
b0 <- c(b0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1)

vcov <- matrix(0, nrow = length(b0), ncol = length(b0))
vcov[upper.tri(vcov, diag = TRUE)] <- runif(.5*length(b0)*(1+length(b0)))
vcov <- t(vcov) \%*\% vcov

list_etas <- censoredElasticity(
Params = b0,
Shares = matrix(c(s1, s2, s3, s4, s5, s6), ncol = 6),
Prices = matrix(c(lnp1, lnp2, lnp3, lnp4, lnp5, lnp6), ncol = 6),
Budget = matrix(testing_data$lnw),
Demographics = matrix(c(age, size, educ, sex), ncol = 4),
quaids = FALSE,
func = mean,
na.rm = TRUE,
vcov = vcov
)
}


}
