#' Cumulative distribution function for t distribution
#'
#' Computes the quantile of the t distribution for n-1 degrees of freedom corresponding to the input value of the sample mean.
#'
#' Do not call ptmean() directly.
#' Pass DISTR="tmean" to cdfinv() when computing intervals for the
#' normal mean when the variance is unknown.
#' The parameter name to be passed to cdfinv() is mean.
#' The additional arguments s2 (sample variance) and
#' n (sample size) are to be passed to cdfinv().
#'
#' @param q coordinate at which the cdf is to be evaluated (named in accordance with R standards)
#' @param mean the assumed normal mean
#' @param s2 the observed sample variance (pass this as an extra argument to cdfinv())
#' @param n the sample size (pass this as an extra argument to cdfinv())
#'
#' @returns The quantile of the t distribution for n-1 degrees of freedom corresponding to the input value of the sample mean.
#'
#' @author Peter E. Freeman, \email{pfreeman@@cmu.edu}
#'
#' @examples
#' cdfinv("tmean","mean",14.35,s2=4.5,n=22) ## returns 13.40946 15.29054
ptmean <- function(q,mean,s2,n)
{
  if ( n == 1 ) stop("At least two observations are required when the variance is unknown.")
  pt((q-mean)/sqrt(s2/n),n-1)
}

